#include "QEI.h"
#define PI 3.141592653589793

QEI::QEI(PinName A,PinName B,int PPR,Timer *timer,Ticker *ticker):chA(A),chB(B)
{
    _timer = timer;
    _ticker = ticker;
    pre_time=0;      //修正1：修正による初期化
    _PPR = PPR;
    init();
}

void QEI::init()
{
    for(int i =0; i<data_sizeof; i++) pulseData[i] = 0;
    NrotDIR = 1;
    Setting_ABstate_Table();

    chA.rise(this,&QEI::PulseCount);
    chA.fall(this,&QEI::PulseCount);
    chB.rise(this,&QEI::PulseCount);
    chB.fall(this,&QEI::PulseCount);

    pre_ABstate = (chA.read() << 1)|(chB.read());
    _timer -> start();
}

void QEI::Setting_ABstate_Table()
{
    for(int i =0; i<15; i++) {
        if     (i == 0b1101 || i == 0b0100 || i == 0b0010 || i == 0b1011) ABstate_Table[i] =  1;
        else if(i == 0b1110 || i == 0b0111 || i == 0b0001 || i == 0b1000) ABstate_Table[i] = -1;
        else                                                              ABstate_Table[i] =  0;
    }
}

void QEI::useAvePRS()
{
    _ticker -> attach_us(this,&QEI::MoveAve_pulse_to_RPS,3000); //3000usごと
}


void QEI::PulseCount()
{
    uint8_t ABstate = (chA.read() << 1)|(chB.read());
    uint8_t ENCstate = (pre_ABstate << 2)|ABstate;
    pre_ABstate = ABstate;

    if(ENCstate == 0b1101 || ENCstate == 0b0100 || ENCstate == 0b0010 || ENCstate == 0b1011) pulse++;
    else if(ENCstate == 0b1110 || ENCstate == 0b0111 || ENCstate == 0b0001 || ENCstate == 0b1000) pulse--;
}


void QEI::MoveAve_pulse()
{
    for(int i =0; i<data_sizeof-1; i++) pulseData[(data_sizeof-1)-i] = pulseData[(data_sizeof-2)-i];
    pulseData[0] = pulse;
    pulseAve = 0;
    for(int i =0; i<data_sizeof; i++) pulseAve += pulseData[i];
    pulseAve /= data_sizeof;
    pulse = 0;
}


void QEI::MoveAve_pulse_to_RPS()
{
    //時間計測
    //static double pre_time=0;  //修正1：これじゃRPS複数とるとやばいことになる
    double current_time = _timer -> read();
    double dt = current_time - pre_time;
    //移動平均算出
    for(int i =0; i<data_sizeof-1; i++) pulseData[(data_sizeof-1)-i] = pulseData[(data_sizeof-2)-i];
    pulseData[0] = pulse;
    pulseAve = 0;
    for(int i =0; i<data_sizeof; i++) pulseAve += pulseData[i];
    pulseAve /= data_sizeof;
    pulse = 0;

    //RPS算出
    rps = pulseAve/(_PPR*4 * dt);

    pre_time = current_time;

}

double QEI::getRPS()
{
    return rps*NrotDIR;
}

double QEI::Odometry(double WheelDia)
{
    return (WheelDia*PI*pulse/_PPR)*NrotDIR;
}

void QEI::rotReverce()
{
    NrotDIR = -1;
}

//パルスの確認
int QEI::returnPulse()
{
    return pulse;
}

//********************処理をもっと頭良さげにしたものが2********************
//*********************違いはコメントアウトで説明*************************
void QEI::useAvePRS2()
{
    _ticker -> attach_us(this,&QEI::MoveAve_pulse_to_RPS2,3333); //3333usごと
}

void QEI::PulseCount2()
{
    uint8_t ABstate = (chA.read() << 1)|(chB.read());
    uint8_t ENCstate = (pre_ABstate << 2)|ABstate;
    pre_ABstate = ABstate;
    pulse += ABstate_Table[ENCstate];  //エンコーダの表を参照するようになった．表の反転でパルスの増減方向が変えられる
}

void QEI::rotReverce2()//表自体を反転させることで正転方向を変更する
{
    for(int i =0; i<15; i++) ABstate_Table[i] *= -1;
}

void QEI::MoveAve_pulse_to_RPS2()
{
    static int WriteNum_of_pulseData = 0;  //古い情報をズラして格納していたが無駄なので消去．代わりに配列のWriteNum_of_pulseDataのところに書き込んでいく
    //時間計測
    double current_time = _timer -> read();
    double dt = current_time - pre_time;
    //移動平均算出
    pulseData[WriteNum_of_pulseData] = pulse;
    WriteNum_of_pulseData == data_sizeof-1 ? WriteNum_of_pulseData = 0 : WriteNum_of_pulseData++;//WriteNum_of_pulseDataが配列以上になったら0に戻す
    pulseAve = 0;
    for(int i =0; i<data_sizeof; i++) pulseAve += pulseData[i];
    pulseAve /= data_sizeof;
    pulse = 0;

    //RPS算出
    rps = pulseAve/(_PPR*4 * dt);

    pre_time = current_time;
}

//MoveAve_pulse_to_RPS2で出したRPS値を返す
double QEI::getRPS2()
{
    return rps;
}

//オドメトリ用関数2
double QEI::Odometry2(double WheelDia)
{
    return (WheelDia*PI*pulse/_PPR);
}