float firmware_version = 1.20;
//OMRON
//#define TRIGGER_0   1
//#define TRIGGER_1   0

//KEYENCE
#define TRIGGER_0   0
#define TRIGGER_1   1


#include "mbed.h"

 #define  BUZZVSP7   // Enable P7 for Buzzer..


//#include "USBSerial.h"

 


//#define USBSerialOption

#ifdef USBSerialOption
#include "USBSerial.h"
USBSerial pc;

#else

//Serial pc(USBTX, USBRX); // SDA serail port
Serial pc(PTE0, PTE1); // tx, rx 


#endif



#include "LiquidCrystal_I2C.h"
#include "mini8i8o5a.h"
#define  EEPROMBUFFERSIZE   16 
#include "eepromlib.h"


DigitalOut myled(LED1);

int loopinilcd=0;

char  str[50];
char  strbuf[50];


int rxchar_count=0;
#define RXBUFFERSIZE 100
char rx_buffer[RXBUFFERSIZE];
char rx_buffer_CMD[RXBUFFERSIZE];
char rx_buffer_ARG[RXBUFFERSIZE];
char rx_pointer=0;
char inchar=0;

char remote_control=0;

float ser_para_reset=0;
//float ser_para_stab=3.25;
float ser_para_time=1.19;
float ser_para_result=0.0;

char ser_para_state=0;
char ser_para_err=0;
char ser_para_range=0;

char  ser_trigger=0;
char  ser_para_cont_mode=1; //serial continue print out

Timer com_timer;


char boardaddress =1;




int CAMERROR =0;
int CAMTOTAL =0;
#define CAMTRIGGER OUT0

#define SCENE_PULSE  OUT1

#define CAMBUSY    IN1


void serial_pc_rx_services()
{
 int i,j;
#ifdef USBSerialOption              
        while (pc.available())
#else
        while(pc.readable())        
#endif        
        {         
         inchar =pc.getc();        
         if ( rx_pointer==0)  //first incoming character clear old buffer
         {
             for (i=0;i<RXBUFFERSIZE;i++) rx_buffer[i]=0; //clear old buffer              
             com_timer.reset();
             com_timer.start();
         }
         
         loopinilcd=0;
         
         rx_buffer[rx_pointer]=inchar; //keep char in buffer...         
         rx_pointer++;
                  
         if (rx_pointer>=(RXBUFFERSIZE-10)) 
         {
            rx_pointer=0;//Error buffer overflow
            pc.printf("ERR:buffer overflow\n"); 
         }
                  
         if ((inchar=='\r')|(inchar=='\n'))
         {
                        
             rx_buffer[rx_pointer-1]=0;//mark end of string, remove terminate char
             
             i=0;
             j=0;
             char cmd_done=0;
             while (rx_buffer[i]!=0)
             {
               if (cmd_done==0)
               {
                 rx_buffer_CMD[i]=rx_buffer[i];//copy cmd part
                 if (rx_buffer_CMD[i]==' ') 
                 { 
                  cmd_done=1;
                  rx_buffer_CMD[i+1]=0; 
                 }
                }
                else
                {
                  rx_buffer_ARG[j]=rx_buffer[i];//copy cmd part 
                  j++;
                }
                i++;
                 
             }
             
             rx_buffer_ARG[j]=0; //end of string ++++
             
          

             #define IDELBUSYLOOP 10000
             BUZZER=1;      
             
                     
             if (rx_buffer[0]=='t')
             {
              //pulse trigger    
              
              
              SCENE_PULSE=0;
              wait(0.050);
              SCENE_PULSE=1;
              wait(0.050);
              
                        
              CAMTRIGGER=TRIGGER_0; //edge trigger
              
              i=0; 
              while(1) //wait camera run busy
              {              
                Input_sampling(8);
                if(CAMBUSY!=0) break;                 
                if (i++>IDELBUSYLOOP) 
                {
                    CAMERROR=1;
                    break;
                }
              } 
              //cmaera process run  
              CAMTRIGGER=TRIGGER_1; //edge trigger                          
              i=0;
              while(1) //wait camera complete run
              {              
                Input_sampling(8);
                if(CAMBUSY==0) break;
                if (i++>IDELBUSYLOOP) 
                {
                  CAMERROR=1;
                  break;
                }
              }              
                           
             }
             else if (rx_buffer[0]=='j')
             {                 
              // wait(0.1);  
             }
             else if (rx_buffer[0]=='r')
             {
               //wait(0.1);                   
             }             
             else if (rx_buffer[0]=='p')
             {
               //wait(0.1);    
               #define PRGLINE0 OUT4
               #define PRGLINE1 OUT5
               #define PRGLINE2 OUT6
               #define PRGLINE3 OUT7
               #define PRG_ON   0
               #define PRG_OFF  1
               
               switch( rx_buffer[1])
               {
                 case '0': PRGLINE3=PRG_OFF;PRGLINE2=PRG_OFF; PRGLINE1=PRG_OFF; PRGLINE0=PRG_OFF; break;
                 case '1': PRGLINE3=PRG_OFF;PRGLINE2=PRG_OFF; PRGLINE1=PRG_OFF; PRGLINE0=PRG_ON ; break;
                 case '2': PRGLINE3=PRG_OFF;PRGLINE2=PRG_OFF; PRGLINE1=PRG_ON ; PRGLINE0=PRG_OFF; break;
                 case '3': PRGLINE3=PRG_OFF;PRGLINE2=PRG_OFF; PRGLINE1=PRG_ON ; PRGLINE0=PRG_ON ; break;
                 case '4': PRGLINE3=PRG_OFF;PRGLINE2=PRG_ON ; PRGLINE1=PRG_OFF; PRGLINE0=PRG_OFF; break;
                 case '5': PRGLINE3=PRG_OFF;PRGLINE2=PRG_ON ; PRGLINE1=PRG_OFF; PRGLINE0=PRG_ON; break;
                 case '6': PRGLINE3=PRG_OFF;PRGLINE2=PRG_ON ; PRGLINE1=PRG_ON; PRGLINE0=PRG_OFF ; break;
                 case '7': PRGLINE3=PRG_OFF;PRGLINE2=PRG_ON ; PRGLINE1=PRG_ON ; PRGLINE0=PRG_ON ; break;
                 case '8': PRGLINE3=PRG_ON ;PRGLINE2=PRG_OFF; PRGLINE1=PRG_OFF; PRGLINE0=PRG_OFF; break;
                 case '9': PRGLINE3=PRG_ON ;PRGLINE2=PRG_OFF; PRGLINE1=PRG_OFF; PRGLINE0=PRG_ON ; break;
                 
                 default:  PRGLINE3=PRG_OFF;PRGLINE2=PRG_OFF; PRGLINE1=PRG_OFF; PRGLINE0=PRG_OFF; break;
                }               
             }
                          
             BUZZER=0;
             Input_sampling(8);
             if (IN0) // Total result
             {
              CAMTOTAL=1;
              OUT1=0;   
             }
             else
             {
              CAMTOTAL=0; 
              OUT1=1;  
             }
             
             
             
             
             //+++++
              pc.printf("%dOK\n",CAMTOTAL+4*CAMERROR); 
              //pc.printf("123OK"); 
              //pc.printf("rxbuffer: %s",rx_buffer); //test direct echo             
             //++++             
             
             //pc.printf("rxbuffer: %s",rx_buffer); //test direct echo
             /*
             if (strcmp(rx_buffer,"*IDN?")==0)
             {
                 pc.printf("Schaffner SerIO, ver %.1f\n",firmware_version);                 
             }
             else if (strcmp(rx_buffer,"*RST")==0)
             {
                pc.printf("Instrumnet Reset\n"); 
                ser_para_reset=1; //pass flag stop all operation 
                //LCDI2C4Bit_init();        
                LiquidCrystal_I2Cinit();
                LCDI2C4Bit_clear();
                //LCDI2C4Bit_backLight(true);
                LiquidCrystal_I2Cbacklight(); 
                
            LCDI2C4Bit_cursorTo(0,0); 
            sprintf (str,"  --- RESET ----");                      
            LCDI2C4Bit_printIn(str);                
                wait(0.25);
              NVIC_SystemReset();//softreser
             }
             else if (strcmp(rx_buffer,":SYS:VER")==0)
             {
                pc.printf("%.1f\n",firmware_version); 
             }
             else if (strcmp(rx_buffer,":SYST:ERR")==0)
             {
                pc.printf("0\n"); 
             }
             //else if (strcmp(rx_buffer,"a11000")==0) //Read Input   "aX1"
             else if  ( (rx_buffer[0]=='a')  & (rx_buffer[1]==('0'+boardaddress))  & (rx_buffer[2]=='1')) // Write Output "aX1"
             {
                pc.printf("%dOK\n",INPUT); 
             }                                                                                                                                                           
             else if  ( (rx_buffer[0]=='a')  & (rx_buffer[1]==('0'+boardaddress))  & (rx_buffer[2]=='2')) // Write Output "aX2"
             {
                //writer
                unsigned char b3,b2,b1;
                unsigned int  outdata=0;
                
                if (rx_buffer[3]!=0)
                {
                  outdata=rx_buffer[3]-'0';
                }
                if (rx_buffer[4]!=0)
                {
                  outdata=outdata*10+rx_buffer[4]-'0';
                }
                if (rx_buffer[5]!=0)
                {                  
                  outdata=outdata*10+rx_buffer[5]-'0';
                }
                int OUTBUF=0;
                if bitchk(outdata,0) {OUT0=ON;OUTBUF=OUTBUF+1;} else OUT0=OFF;
                if bitchk(outdata,1) {OUT1=ON;OUTBUF=OUTBUF+2;} else OUT1=OFF;
                if bitchk(outdata,2) {OUT2=ON;OUTBUF=OUTBUF+4;} else OUT2=OFF;
                if bitchk(outdata,3) {OUT3=ON;OUTBUF=OUTBUF+8;} else OUT3=OFF;

                if bitchk(outdata,4) {OUT4=ON;OUTBUF=OUTBUF+16;} else OUT4=OFF;
                if bitchk(outdata,5) {OUT5=ON;OUTBUF=OUTBUF+32;} else OUT5=OFF;
                if bitchk(outdata,6) {OUT6=ON;OUTBUF=OUTBUF+64;} else OUT6=OFF;
                if bitchk(outdata,7) 
                {OUT7=ON;OUTBUF=OUTBUF+128;
                #ifdef BUZZVSP7
                   BUZZER=1;
                #endif
                
                } 
                else 
                {
                #ifdef BUZZVSP7
                   BUZZER=1;
                #endif
                
                    
                    OUT7=OFF;
                    }
                OUTPUT=OUTBUF;                                
                pc.printf("%dOK\n",outdata); 
             }                                                                                                                                                           
             else if  ( (rx_buffer[0]=='a')  & (rx_buffer[1]==('0'+boardaddress))  & (rx_buffer[2]=='3')) // Write Output "aX2"
             {
                pc.printf("%dOK\n",OUTPUT); 
             }                                                                                                                                              
             else
             {//unknow / handle comand               
               //pc.printf( "UNKNOWN %s=>%s,%s\n",rx_buffer,rx_buffer_CMD,rx_buffer_ARG);                 
               pc.printf( "UNKNOWN %s=>%s,%s\n",rx_buffer);
             }       
             
             
             */
             
             
             
                   
             rx_pointer=0;//Reset at the end  
             com_timer.stop();                           
             break;//exit while
         } //end foud "terminal of command//
                 
         
         
        } //end while data read aviable
        
               

}


int main() 
{
    int i=0;
    
    OUT1=0;
   
  LiquidCrystal_I2C_SETUP(0x27,20,4);
  LiquidCrystal_I2Cinit();       
  LiquidCrystal_I2Cbacklight();       
   
  LiquidCrystal_I2CsetCursor(0,1); 
  sprintf (str, "   SCHAFFNER  ");                 
  LCDI2C4Bit_printIn(str); 
  LiquidCrystal_I2CsetCursor(0,0); 
  sprintf (str, "SerailVIS v:%.2f ",1.01)       ;         
  LCDI2C4Bit_printIn(str);   
   
#ifdef USBSerialOption              
        
#else
  pc.baud(9600);  // set what you want here depending on your terminal program speed         
#endif     
  
  
  com_timer.start();
  com_timer.stop();  
  com_timer.reset();
  
  wait(0.1);
    
  pc.attach(&serial_pc_rx_services);  // Use interrupt services !!
  
  OUT1=0;
  SCENE_PULSE=1;

#define  BUZZER_EN    0 

// while(1);

#define MANUAL_RUNEANABLE 

#ifdef MANUAL_RUNEANABLE 
CAMTRIGGER=TRIGGER_0; // set signal ready for cam trigger
float analog=  0;
float analogPG=0;


load_eeprom();
while(1); //++++++++++++++++++++++++++

while(1)
{
     analog=ain0; //read trigger switch ( analog key ) 
     analogPG=ain1; //read program number by analog switch
     
     if (eedata[0]==0)
     {
      PRGLINE3=PRG_OFF;PRGLINE2=PRG_OFF; PRGLINE1=PRG_OFF; PRGLINE0=PRG_OFF; 
     LiquidCrystal_I2CsetCursor(0,1); 
     //sprintf (str, "an:%f       ",analog);                 
     sprintf (str, "PG0         ");                 
     LCDI2C4Bit_printIn(str);  
     
    //save_eeprom();     
    }
    else
    {
      PRGLINE3=PRG_OFF;PRGLINE2=PRG_OFF; PRGLINE1=PRG_OFF; PRGLINE0=PRG_ON; 
     LiquidCrystal_I2CsetCursor(0,1); 
    // sprintf (str, "an:%f       ",analog);                 
     sprintf (str, "PG1         ");                 
     LCDI2C4Bit_printIn(str);  
    }

if (IN4==0)    
{
     if (eedata[0]==0)
     {
     eedata[0]=1;
    }
    else
    {
        eedata[0]=0;
    }    
  save_eeprom();  
  while(IN4==0);
  wait(0.5);
    
}    
    
if (analog<0.6)  
{
       //++++++++++++++++++++++++++++++++++++++++
               //pulse trigger              
              CAMTRIGGER=TRIGGER_0; //edge trigger
              i=0; 
              while(1) //wait camera run busy
              {              
                Input_sampling(8);
                if(CAMBUSY!=0) break;                 
                if (i++>IDELBUSYLOOP) 
                {
                    CAMERROR=1;
                    break;
                }
              } 
              //cmaera process run  
              CAMTRIGGER=TRIGGER_1; //edge trigger                          
              i=0;
              while(1) //wait camera complete run
              {              
                Input_sampling(8);
                if(CAMBUSY==0) break;
                if (i++>IDELBUSYLOOP) 
                {
                  CAMERROR=1;
                  break;
                }
              }              
  LiquidCrystal_I2CsetCursor(0,0); 
  sprintf (str, "Trig..          ")       ;         
  LCDI2C4Bit_printIn(str); 
              
             wait(1.0); //wait cam finish process            
             Input_sampling(8);
             if (IN0) // Total result
             {
  LiquidCrystal_I2CsetCursor(0,0); 
  sprintf (str, "FAIL..  ")       ;         
  LCDI2C4Bit_printIn(str); 
              
              CAMTOTAL=1;
              OUT1=0;   
             }
             else
             {
  LiquidCrystal_I2CsetCursor(0,0); 
  sprintf (str, "PASS..  ")       ;         
  LCDI2C4Bit_printIn(str); 
              
              CAMTOTAL=0; 
              OUT1=1; 
              wait(1.0);
              OUT1=0; 
             }    
    
      LiquidCrystal_I2Cinit();       
     LiquidCrystal_I2Cbacklight();       
  LiquidCrystal_I2CsetCursor(0,0); 
  sprintf (str, "Ready..")       ;         
  LCDI2C4Bit_printIn(str); 
    
 //++++++++++++++++++++++++++++++++   
}    
}
#endif


 
  while(0)
  {
    if (BUZZER_EN!=0) BUZZER=1;
    OUT0=0;
    wait(0.1);
    if (BUZZER_EN!=0) BUZZER=0;
    wait(0.1);
    OUT0=1;  
    
         
    wait(1.0);  
    
    
  }
  
  
  while(1) 
  {
     
     if (loopinilcd++>100)
     {        
        loopinilcd=0;
        LiquidCrystal_I2Cinit();       
        LiquidCrystal_I2Cbacklight();                   
     }
     
     Input_sampling(512);
     LiquidCrystal_I2CsetCursor(0,0); 
     sprintf (str, "IN:%d OUT:%d         ",INPUT,OUTPUT);                 
     LCDI2C4Bit_printIn(str);      
     LiquidCrystal_I2CsetCursor(0,1); 
     
     
     float processtime=1000.0*com_timer.read();
     if (processtime<10.0)
     {
       sprintf (str, "%.1f ms:%s       ",processtime,rx_buffer);                 
    }
    else
    {
       sprintf (str, " %.1f ms:%s       ",processtime,rx_buffer);                 
    }        
        
     LCDI2C4Bit_printIn(str); 
    
    
    
     char strbuf[50];
     
     
     LiquidCrystal_I2CsetCursor(0,3); 
     sprintf (str, "#");                 
     sprintf (strbuf, " "); 
     
     if (OUT0)
     { 
       sprintf (strbuf, "K1 ");   
       strcat(str,strbuf);
     }     
     
     if (OUT1)
     { 
       sprintf (strbuf, "K2 ");   
       strcat(str,strbuf);
     }     
     
     if (OUT2)
     { 
       sprintf (strbuf, "K3 ");   
       strcat(str,strbuf);
     }     
     
     if (OUT3)
     { 
       sprintf (strbuf, "K4 ");   
       strcat(str,strbuf);
     }     
     
     



     if (OUT4)
     { 
       sprintf (strbuf, "RE ");   
     } 
     else
     { 
       sprintf (strbuf, "V.");   
     }                   
     strcat(str,strbuf);
     
     if (OUT5)
     { 
       sprintf (strbuf, "AC ");   
     }              
     else
     {
       sprintf (strbuf, "DC ");                   
     }
     strcat(str,strbuf);
     
     if (OUT6)
     { 
       sprintf (strbuf, "Di ");   
       strcat(str,strbuf);
     }              
     
     if (OUT7)
     { 
       sprintf (strbuf, "POW ");   
       strcat(str,strbuf);
     }  
     sprintf (strbuf, "   ");               
     strcat(str,strbuf);
     
     
     LCDI2C4Bit_printIn(str); 
     
     
     
     
     if (com_timer.read()>5.0) 
     {
       rx_pointer=0;//Reset at the end  
       com_timer.stop();           
     }

  }
  
  
}
