//#include "mbed.h"
// 
//SPI spi(A1, A2, A3); // mosi, miso, sclk
//DigitalOut cs(A0);
//
//uint8_t tx_buf[32] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V'};
//
//int main() {
//    // Chip must be deselected
//    cs = 1;
// 
//    // Setup the spi for 8 bit data, high steady state clock,
//    // second edge capture, with a 1MHz clock rate
//    spi.format(8,1);
//    spi.frequency(8000000);
// 
//    // Select the device by seting chip select low
//    cs = 0;
// 
//    for(int i=0; i<32; i++)
//        spi.write(tx_buf[i]);
//    printf("End of transmission \r\n");
//     
//    // Deselect the device
//    cs = 1;
//}

#include "mbed.h"
#include "SPISlave_multiByte.h"

#include "EthernetInterface.h"
#include "WIFIDevice.h"

SPISlave_multiByte device(A1, A2, A3, p3); // mosi, miso, sclk, ssel
//SPISlave_multiByte device(p15, p9, p11, p29); // mosi, miso, sclk, ssel
//SPISlave_multiByte device(A1, A0, A3, A2); // mosi, miso, sclk, ssel
Serial uart(USBTX, USBRX);
DigitalOut myled(LED1);

char* TCP_SERVER_ADDRESS = "192.168.2.7";
int TCP_SERVER_PORT = 1030;

inline void hexview(const char *buffer, unsigned int size) {
    char byte[50];
    char text[20];
    bool big = false;
    int i;
    for(i = 0; i < size; ++i) {
        if((i&0xF) == 0x0) {
            if(big)
                printf("%04X: %-49s: %-20s\n", (i&~0xF), byte, text);
            big = false;
            byte[0] = '\0';
            text[0] = '\0';
        } else if((i&0xF) == 0x8) {
            big = true;
            byte[(i&0xF) * 3] = ' ';
            text[(i&0xF)] = ' ';
        }
        unsigned char value = buffer[i];
        text[(i&0xF) + 0 + big] = (value < 0x20 || value > 0x7F)? '.': value;
        text[(i&0xF) + 1 + big] = '\0';
        value = (buffer[i] &0xF0) >> 4;
        byte[(i&0xF) * 3 + 0 + big] = (value < 0xA)? (value + 0x30): (value + 0x37);
        value = (buffer[i] &0x0F);
        byte[(i&0xF) * 3 + 1 + big] = (value < 0xA)? (value + 0x30): (value + 0x37);
        byte[(i&0xF) * 3 + 2 + big] = ' ';
        byte[(i&0xF) * 3 + 3 + big] = '\0';
    }
    if(byte[0]) {
        uart.printf("%04X: %-49s: %-20s\n", (i&~0xF), byte, text);
    }
    uart.printf("\n");
}

void scanCallback(tstrM2mWifiscanResult result)
{
    printf("SSID: %s \n", result.au8SSID);
    printf("RSSI: %i \n", result.s8rssi);
}

int main() {
    uart.baud(115200);
    uart.printf("START!");
    device.format(8,0);  
    myled = 1;

    EthernetInterface eth;
    WIFIDevice wifi;

    eth.init();

    wifi.apScan(scanCallback);
             
    wifi.setNetwork(M2M_WIFI_SEC_WPA_PSK, "TWCYNPC0209_Mac mini", "mayday55555"); 
    
    eth.connect();    

    if(wifi.is_AP_connected())
        uart.printf("Connect Success! \n");
    else
        uart.printf("Connect Fail! \n");    

    TCPSocketConnection tcp; 
    tcp.set_blocking(false, 1500);
    tcp.connect(TCP_SERVER_ADDRESS, TCP_SERVER_PORT);
    
    char out_buffer[] = "Hello World";
                
   while(1) {
    
    uart.printf("Add: %p \r\n", device.read());
    //uart.printf("%c \r\n", device.read());
    
    while (!device.readable()) {
        __WFE();
    }
    hexview((const char *)0x20003384, 224);
    //hexview((const char *)ptr, 224);
    //uart.printf("%c\r\n",m_rx_buf[3]);
    
    tcp.send(out_buffer, strlen(out_buffer));
        
    myled = !myled;
    wait_ms(200);
   }
}