#include "mbed.h"
 
SPI spi(D3, D4, D5); // mosi, miso, sclk
DigitalOut cs(D2);
 
int main() {
    // Chip must be deselected
    cs = 1;
 
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(1000000);

    printf("Start application \r\n");   
    // Select the device by seting chip select low
    cs = 0;
 
    spi.write(0x5);
    spi.write(0x20);
    spi.write(0x00);
    spi.write('A');
    spi.write('B');
    spi.write('C');
    
    spi.write(0xFF);
    spi.write(0xFE);
    spi.write(0xFD);
    spi.write(0xFC);
          
    wait_ms(100);

    // Deselect the device
    cs = 1;
    printf("End of application \r\n");    
}