/******************** (C) COPYRIGHT 2016 Delta Electronics, Inc. ***************
*
* File Name : main.cpp
* Authors   : Tsungta Wu - CPBG (tsungta.wu@deltaww.com)
* Version   : V.1.0.0
* Date      : 2016/Nov/24
*
* This example only show the most basic WiFi operation include AP scan and connect 
* The usage of TCP/UDP socket please refer to the mbed Handbook from the link below
* https://developer.mbed.org/handbook/Socket
*
*******************************************************************************/

#include "mbed.h"
#include "EthernetInterface.h"
#include "WIFIDevice.h"

const char* ECHO_SERVER_ADDRESS = "172.20.10.3";
const int ECHO_SERVER_PORT = 1030;

Serial uart(p17, p16);//temporary define for alpha release

int main() {

    EthernetInterface eth;
    WIFIDevice wifi;
    
    uart.baud(9600);
    
    eth.init();
    uart.printf("MAC: %s\n", eth.getMACAddress());

    wifi.setNetwork(M2M_WIFI_SEC_WPA_PSK, "Tsungta_iPhone", "icq87001"); 
    
    eth.connect();
    printf("IP: %s\n", eth.getIPAddress());
    printf("Gateway: %s\n", eth.getGateway());
    printf("NetworkMask: %s\n", eth.getNetworkMask());

    if(wifi.is_AP_connected())
        uart.printf("Connect Success! \n");
    else
        uart.printf("Connect Fail! \n");     

    UDPSocket sock;
    sock.init();
    
    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
    
    char out_buffer[1400] = "Hello World";
    uart.printf("Sending  message '%s' to server (%s)\n",out_buffer,ECHO_SERVER_ADDRESS);
    while(1)
        sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));
    
    sock.close();
    
    eth.disconnect();                             
    
    wifi.sleep();
                                 
    while(1) {
    }
}

