/////////////////////////////////////////////////////////////////////
//  Dose Meter Test Program                                        //
//  for ADC Measurement Timer(0.1mSec)Interrupt & DAC Controll           //
//   Since 2013.08.01  H.Tsunemoto                                 //
//   Sample Program Import (1) Serial_interrupt                    //
//                         (2) Timer_Interrupt(100mSec) Sample     //
//                         (3) Internal_ADC_with_interrupt         //
/////////////////////////////////////////////////////////////////////

#include "mbed.h"
#include "stdio.h"
#include "math.h"
#include "LPC17xx.h" 
// Serial TX & RX interrupt loopback test using formatted IO - sprintf and sscanf
// Connect TX to RX (p9 to p10)
// or can also use USB and type back in the number printed out in a terminal window
// Sends out ASCII numbers in a loop and reads them back
// Since 2013.08.
// If not the same number LED4 goes on
// LED1 and LED2 ADC
// LED3 changing indicate main loop running

//-------------------------------------//
// --- MBED I/O Asign  declaration --- //
//-------------------------------------//
// Serial Port Asign P9:TX P10:RX
Serial device(USBTX, USBRX); // tx, rx  //Serial device(p9, p10);  // tx, rx
// ADC Port Asign P15: ad_ch1  P16 = ad_ch2
AnalogIn ad_ch1(p15); // AD CH1
AnalogIn ad_ch2(p16); //AD CH2
AnalogIn ad_ch3(p17); //AD CH2
AnalogOut dac_output(p18);

// Can also use USB and type back in the number printed out in a terminal window
// Serial monitor_device(USBTX, USBRX);
DigitalOut led1(LED1);          // ADC Active
DigitalOut led2(LED2);          // ADC Input Cycle
DigitalOut led3(LED3);          // Main Loop Cycle
DigitalOut led4(LED4);          // DAC Active
BusOut leds(LED4,LED3,LED2,LED1); //LED

//---------------------------------------------------------//
//   <<< ADC Sample Parameter & Function declaration >>>   //
//---------------------------------------------------------//
//----  ADC Interrupt Timer -----//
int main_loop_count = 0;
Ticker ADC_Timer;
Timer t;
int ADC_Count1=0;
int ADC_Count1Block=0;
#define ADC_BUFF_SIZE  5000
#define ADC_CH1 0
#define ADC_CH2 1
#define ADC_CH3 2
volatile unsigned short Adc_inp_temp[3];
volatile unsigned short Adc_buff[3][ADC_BUFF_SIZE];
volatile int adc_buff_inp = 0;
volatile int adc_buff_out = 0;
// Ative Mode Status Controll
#define ActiveMode_ADC_Sample_Stop 0
#define ActiveMode_ADC_Sample_Ready 1  // 
#define ActiveMode_ADC_Sample_Busy  2  //
int i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
// Trigger Mode Status Control
#define ADC_TRIGGER_READY   0    //Trigger Mode Ready :Trigger Wait & No Data Send
#define ADC_TRIGGER_BUSY    1    //Trigger Mode Busy  :Trigger Detected & Sample Data Send
#define ADC_TRIGGER_END     2    //Trigger Mode END  :Sample End & Data Send Done Wait
int i_adc_Trigger_Sample_Status = ADC_TRIGGER_READY;
volatile unsigned short adc_CH1_now;
volatile int i_adc_trigger_end_count;
int i_adc_Waveform_count=0;
volatile int i_adc_Sample_Total_Count = 0;
volatile int i_adc_Sample_Total_Time = 0;
#define ADC_TRIGGER_START_ENABLE 1
#define ADC_TRIGGER__START_READY 0
bool b_Trigger_Start_sendFlag = ADC_TRIGGER__START_READY;
#define ADC_PULSE_END_ENABLE 1
#define ADC_PULSE_END_READY  0
bool b_Trigger_EndFlag = ADC_PULSE_END_READY;
#define ADC_SAMPLE_AVE_MAX 4
volatile int adc_Sample_Ave_Count = 4;
typedef struct st_adc_ave{
    volatile unsigned short sample_Add;
    volatile unsigned short sample_Max;
    volatile unsigned short sample_Min;
}ST_ADC_AVE;
volatile ST_ADC_AVE st_adc_sample_ave[3];
const ST_ADC_AVE const_ADC_AVE_Default=
{
    0           //unsigned short sample_Add;
    ,0          //unsigned short sample_Max;
    ,0xfff     //unsigned short sample_Min;
};
#define ADC_SAMPLE_RATE_MIN  5
#define ADC_SAMPLE_RATE_MAX  20000
#define ADC_SAMPLE_RATE_MIN_f  0.005f
#define ADC_SAMPLE_RATE_MAX_f  20.000f
#define ADC_PRE_TRIG_MIN 0
#define ADC_PRE_TRIG_MAX 100
#define ADC_PULSE_END_MIN_f   0.1f  //0.1Sec
#define ADC_PULSE_END_MAX_f   5.0f  //5.0Sec

//-------- ADC Measure Mode Parameter declaration  --------//
typedef struct  st_adc_param{
    int   i_sample_interval; // DAC Output Pattern
    float f_trigger_level;
    unsigned short us_trigger_level;    // (3.3f/1023) * f_trigger_level (Image)
    int i_pre_trig_point;
    int i_pulse_end_time;
}ST_ADC_PARAM;

ST_ADC_PARAM st_adc_mode_param;

//-------- ADC Measure Mode Parameter Default Set  --------//
const ST_ADC_PARAM const_ADC_Param_Default=
{
        1000       //i_sample_int=1000 microS
        ,0.01f       //f_trigger_level = 0.01V
        ,0x00c      // (3.3f/4095) * f_trigger_level
        ,5      // i_pre_trig_point = 5 point before
        ,12000       //i_pulse_end_time = 1.2 Sec
};
//int adc_sample_interval = 1000;  // ADC Sample Rate 5 - 20000(20.0mSec)
void ADC_ave_Init();
void Start_ADC();
int ADC_Inp3CH();
void ADC_Interrupt();
void ADC_Stop();
void ad_sample_send();
void adc_param_init();




//--------------------------------//
// --- Serial Communication  ---  //
//--------------------------------//
void Tx_interrupt();
void Rx_interrupt();
void send_line();
int read_line();  // Return Rec CHAR Count 2013.08.08 Tsunemoto Append



//---------- H.Tsunemoto Scince 2013.08.08  ---------// 
//-----------------------------------------------------------//
//--------- Timer Innterrupt For DAC Control  ---------------//
//-----------------------------------------------------------//
int timer_count=0;
int timer_1Sec=0;

//void TIMER0_IRQHandler(void);
void timer0_init(void);
//---------  New Append Function  ---------//

void dac1_param_init();
void Ser_Command_Input();
//////////////////////////////////////////////////////////////////////////////////
//------------    Command Check & Set Function ---------------------------------//
// ADC No.1 "ARx.xx"  ADC Sample Rate
bool com_Check_AR(int i_RecCharCount);
// ADC No.2 "ALx.xxx" ADC Trigger Limit Level 0.00-3.3V
bool com_Check_AL(int i_RecCharCount);
// ADC No.3 "APxx"  ADC PreTrigger Send Data Point
bool com_Check_AP(int i_RecCharCount);
// ADC No.4 "AIx.xxx" ADC Pulse End Point Check Time
bool com_Check_AI(int i_RecCharCount);
// ADC No.5
void com_ADC_Table_Param_Send();
//  DAC_No.1  "DMn:xx (SINGLE/PULSE/TRIANGLE)                                       //
bool com_Check_DM(int i_RecCharCount);
//  DAC_No.2  "DHn:xx.x  Pulse High Level Volt Set  (0.000 - 3.300[V])              //
bool com_Check_DH(int i_RecCharCount);
//  DAC_No.3  "DLn:xx.x  Pulse Low Level Volt Set   (0.000 - 3.300[V])              //
bool com_Check_DL(int i_RecCharCount);
//  DAC_No.4  "DPn:xx.x  Pulse Mode Pulse Width Set   (0.1 - 2000.0[mSec])          //
bool com_Check_DP(int i_RecCharCount);
//  DAC_No.5  "DIn:xx.x  Pulse Mode Pulse Interval Set                              //
bool com_Check_DI(int i_RecCharCount);
//  DAC_No.6  "DWn:xx.x  Wave Form Total Width Set                                  //
bool com_Check_DW(int i_RecCharCount);
//  DAC_No.7  "D?"  DAC Parameter RepryWave Form Total Width Set                    //
void com_Table_Param_Send();
//----------------------------------------------------------------//

// Circular buffers for serial TX and RX data - used by interrupt routines
const int ser_buffer_size = 255;
// might need to increase buffer size for high baud rates
char tx_buffer[ser_buffer_size];
char rx_buffer[ser_buffer_size];
// Circular buffer pointers
// volatile makes read-modify-write atomic
volatile int tx_in=0;
volatile int tx_out=0;
volatile int rx_in=0;
volatile int rx_out=0;
// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];
//---  2013.08.08 Tsunemoto ------//
//--  rx Data Cr Rec Counter
volatile int rx_cr_Rec = 0;
//--------------------------------//


// ---------------------------------------------------------------//
// 2013.08.07 Tsunemoto
// Measurement Grobal Parameter
// ---- DAC 1 Digit Unit ----------//
//  10Bits = 1023 : VREFP = 3.3V
//#define DAC_1_DIGIT_VOLT (0.0032258f)
#define DAC1_FULL_VOLT_f  3.30f 
#define DAC1_PULSE_INT_MAX_f 3000.0f 
#define DAC1_PULSE_TOTAL_TIME_MAX_f 500.0000f 
//unsigned short us_Dac1_volt;
float f_Dac1_volt;
float f_Dac_Triangle_inc;
//---  DAC OutPut Pattern  ---//
// ---  DAC Active Pattern  ---//
#define DAC1_PATERN_0 0
#define DAC1_PATERN_1 1
#define DAC1_PATERN_2 2
int i_dac1_pattern_now = DAC1_PATERN_0;  // Active Pattern 0,1,2
//--- DAC Active MODE ---//
#define DAC1_ACT_0_READY 0  // NO Active
#define DAC1_ACT_1_START 1  // START Command Input
#define DAC1_ACT_2_OUTPUT_BUSY 2// PULSE PATTERN ACTIVE  
int i_dac1_active_status;
int i_dac1_active_count; //OUTPUT_WAVE TOTAL COUNT 0-500S:0-500000(0x7A120)
int i_dac1_pulse_count;     //OUTPUT PULSE COUNT
#define DAC1_PULSE_ACT_INTERVAL 0
#define DAC1_PULSE_ACT_UP 1
#define DAC1_PULSE_ACT_DOWN 2
int i_dac1_pulse_act = DAC1_PULSE_ACT_INTERVAL;
//---  DAC1 Pattern Parameter 
#define DAC1_PATTERN_1_SINGLE_PULSE 0
#define DAC1_PATTERN_2_PULSE 1
#define DAC1_PATTERN_3_TRIANGLE 2
#define DAC1_PATTERN_MAX 3
typedef struct  st_dac_param{
    int i_pattern; // DAC Output Pattern
    float f_pulse_high;
    float f_pulse_low;

    int i_pulse_width;
    int i_pulse_interval;
    int i_Total_time;    
}ST_DAC_PARAM;

ST_DAC_PARAM st_dac1_param[DAC1_PATTERN_MAX];
const ST_DAC_PARAM const_DAC1_Default[DAC1_PATTERN_MAX]=
{
// Pattern 1
        DAC1_PATTERN_1_SINGLE_PULSE
        ,(3.0f/3.300f)
        ,0.0f
        ,100       // Not Use
        ,3000       //Not Use
       ,1000       // 10mSe
//        ,50000       // 5Sec
// Pattern 2
        ,DAC1_PATTERN_1_SINGLE_PULSE
        ,(0.3f/3.300f)
        ,0.0f
        ,100       // Not Use
        ,3000       //Not Use
        ,50000       // 5Sec
// Pattern 3
        ,DAC1_PATTERN_2_PULSE
        ,(3.0f/3.300f)
        ,0.0f
        ,100       // 10mSec
        ,3000       //300mSec
        ,50000       // 5Sec

        
};

/////////////////////////////////////////////////////////////////
//              <<<<  Main Function  >>>>                      //
/////////////////////////////////////////////////////////////////
// ---------------------------------------------------------------// 
// main test program
int main() {
    // Serial Speed Set 
    device.baud(115200);

// Setup a serial interrupt function to receive data
    device.attach(&Rx_interrupt, Serial::RxIrq);
// Setup a serial interrupt function to transmit data
    device.attach(&Tx_interrupt, Serial::TxIrq);

// Formatted IO test using send and receive serial interrupts
// Timer 0 Interrupt Initial Set //    
    timer0_init();
    timer_count = 0;

//--- ADC Measurement Control Parameter Initial Set ---//
    adc_param_init(); 
//--- DAC Control Parameter Init --- //
    dac1_param_init();
// -- Main Loop -- //
    while (1) {
            if (i_adc_ActiveMode_status != ActiveMode_ADC_Sample_Stop){
            
                ad_sample_send();// --- ADC Sample & Serial Data Out  ---  //
            }
            if(rx_cr_Rec != 0){
                Ser_Command_Input();
            }
             main_loop_count++;
             if(main_loop_count>=100000){
                led3 = (led3+1) & 1;
                main_loop_count = 0;
             }
            /////////////////////////////////
      }
}

//////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------//
//-------     A/D Input & Data Send(Serial)                              -------//
//------------------------------------------------------------------------------//
// int ADC_Count1=0;                                                            //
// int ADC_Count1Block=0;                                                       //
// #define ADC_BUFF_SIZE  5000                                                   //
// #define ADC_CH1 0                                                            //
// #define ADC_CH2 1                                                            //
// #define ADC_CH3 2                                                            //
// unsigned short Adc_buff[3][ADC_BUFF_SIZE]                                     //
// int adc_buff_inp = 0;                                                        //
// int adc_buff_out = 0;                                                        //
//
//#define ActiveMode_ADC_Sample_Stop 0
//#define ActiveMode_ADC_Sample_Ready 1  // 
//#define ActiveMode_ADC_Sample_Busy  2  //
//int i_adc_ActiveMode_status ;
//                                                                              //
//#define ADC_TRIGGER_START_ENABLE
//#define ADC_TRIGGER__START_READY
//bool b_Trigger_Start_sendFlag = ADC_TRIGGER__START_READY;
//#define ADC_PULSE_END_ENABLE
//#define ADC_PULSE_END_READY
//bool b_Trigger_EndFlag = ADC_PULSE_END_READY;
//int i_adc_Waveform_count=0
//int i_adc_Sample_Total_Count = 0;
//int i_adc_Sample_Total_Time = 0;
//
//////////////////////////////////////////////////////////////////////////////////
void ad_sample_send(){
float f_num;
   // A/D  CH1(P15) / CH2(P16) / CH3(P17)  => HEX SHORT 
    if(i_adc_ActiveMode_status == ActiveMode_ADC_Sample_Ready){
        if (b_Trigger_Start_sendFlag == ADC_TRIGGER_START_ENABLE){
            sprintf(tx_line,"PULSE_START:%05d\r\n",i_adc_Waveform_count);
            send_line();
            b_Trigger_Start_sendFlag = ADC_TRIGGER__START_READY;
        }
        if(i_adc_Trigger_Sample_Status != ADC_TRIGGER_READY){
            if(adc_buff_inp != adc_buff_out){
                sprintf(tx_line,"%03x%03x%03x\r\n"
                        ,Adc_buff[ADC_CH1][adc_buff_out]
                        ,Adc_buff[ADC_CH2][adc_buff_out]
                        ,Adc_buff[ADC_CH3][adc_buff_out]
                        ); 
               adc_buff_out = ((adc_buff_out + 1) % ADC_BUFF_SIZE);
               send_line();
            }
        }
        if((adc_buff_inp == adc_buff_out)&& (b_Trigger_EndFlag == ADC_PULSE_END_ENABLE)){
                f_num = ((float)i_adc_Sample_Total_Time + 0.5f)/10.0f;         
                sprintf(tx_line,"PULSE_END:%05d:SAMPLE:%05d,TIME:%06.1f[mSec]\r\n",i_adc_Waveform_count,i_adc_Sample_Total_Count,f_num);
                send_line();
                b_Trigger_EndFlag = ADC_PULSE_END_READY;
        }

    }    
    else if(adc_buff_inp != adc_buff_out){
            sprintf(tx_line,"%03x%03x%03x\r\n"
                        ,Adc_buff[ADC_CH1][adc_buff_out]
                        ,Adc_buff[ADC_CH2][adc_buff_out]
                        ,Adc_buff[ADC_CH3][adc_buff_out]
                        ); 
           adc_buff_out = ((adc_buff_out + 1) % ADC_BUFF_SIZE);
            send_line();
    }
}

void Start_ADC() {
    ADC_Count1Block=0;
    ADC_Count1=0;

    t.reset();
//    t.start();
    //memset(Samples, 0, AANTAL_SAMPLES);
    //ADC_Timer.attach_us(&ADC_Interrupt, 200);
    // 2013_0827 Tsunemoto for 1/4Sample Average
    ADC_Timer.attach_us(&ADC_Interrupt, (st_adc_mode_param.i_sample_interval>>2));
    ADC_ave_Init();
    //ADC_Timer.attach_us(&ADC_Interrupt, st_adc_mode_param.i_sample_interval);
    i_adc_Waveform_count = 0;
    t.start();
     led1 = 1;

 //   wait(0.0005);
}
//*********************************************
//**    ADC 1/4 Sample Parameter init  **
//** 2013.08.27 Tsunemoto              **
//typedef struct st_adc_ave{
//    unsigned short sample_Add;
//    unsigned short sample_Max;
//    unsigned short sample_Min;
//}ST_ADC_AVE;
//ST_ADC_AVE st_adc_sample_ave[3];
//const ST_ADC_AVE const_ADC_AVE_Default=
//#define ADC_SAMPLE_AVE_MAX 4
//int adc_Sample_Ave_Count = 4;
//*************************************** 
void ADC_ave_Init()
{
    int i;
    for (i=ADC_CH1;i<=ADC_CH3;i++){
        st_adc_sample_ave[i].sample_Add = const_ADC_AVE_Default.sample_Add;
        st_adc_sample_ave[i].sample_Max = const_ADC_AVE_Default.sample_Max;
        st_adc_sample_ave[i].sample_Min = const_ADC_AVE_Default.sample_Min;
    }
    adc_Sample_Ave_Count = ADC_SAMPLE_AVE_MAX;
}
//****************************************************
//** ADC Sample Input for 1/4 Ave & MAX/Min Cansel  **
//Adc_inp_temp
// return ;0= No Buffer inc
//         1= Buffer Inp & Count INC
//****************************************************
int ADC_Inp3CH()
{
int i_ret=0;
        Adc_inp_temp[ADC_CH1] = ((ad_ch1.read_u16()>>4)&0xFFF);
        Adc_inp_temp[ADC_CH2] = ((ad_ch2.read_u16()>>4)&0xFFF);
        Adc_inp_temp[ADC_CH3] = ((ad_ch3.read_u16()>>4)&0xFFF);
        adc_Sample_Ave_Count--;
        // CH1 Ave 
        st_adc_sample_ave[ADC_CH1].sample_Add = st_adc_sample_ave[ADC_CH1].sample_Add+Adc_inp_temp[ADC_CH1];
        if(Adc_inp_temp[ADC_CH1] >= st_adc_sample_ave[ADC_CH1].sample_Max){
            st_adc_sample_ave[ADC_CH1].sample_Max = Adc_inp_temp[ADC_CH1];
        }
        if(Adc_inp_temp[ADC_CH1] < st_adc_sample_ave[ADC_CH1].sample_Min){
            st_adc_sample_ave[ADC_CH1].sample_Min = Adc_inp_temp[ADC_CH1];
        }
        // CH2 Ave 
        st_adc_sample_ave[ADC_CH2].sample_Add = st_adc_sample_ave[ADC_CH2].sample_Add+Adc_inp_temp[ADC_CH2];
        if(Adc_inp_temp[ADC_CH2] >= st_adc_sample_ave[ADC_CH2].sample_Max){
            st_adc_sample_ave[ADC_CH2].sample_Max = Adc_inp_temp[ADC_CH2];
        }
        if(Adc_inp_temp[ADC_CH2] < st_adc_sample_ave[ADC_CH2].sample_Min){
            st_adc_sample_ave[ADC_CH2].sample_Min = Adc_inp_temp[ADC_CH2];
        }
        // CH3 Ave 
        st_adc_sample_ave[ADC_CH3].sample_Add = st_adc_sample_ave[ADC_CH3].sample_Add+Adc_inp_temp[ADC_CH3];
        if(Adc_inp_temp[ADC_CH3] >= st_adc_sample_ave[ADC_CH3].sample_Max){
            st_adc_sample_ave[ADC_CH3].sample_Max = Adc_inp_temp[ADC_CH3];
        }
        if(Adc_inp_temp[ADC_CH3] < st_adc_sample_ave[ADC_CH3].sample_Min){
            st_adc_sample_ave[ADC_CH3].sample_Min = Adc_inp_temp[ADC_CH3];
        }
        
        if(adc_Sample_Ave_Count == 0){
//       Adc_buff[ADC_CH1][adc_buff_inp] = adc_CH1_now = ((ad_ch1.read_u16()>>4)&0xFFF);
//       Adc_buff[ADC_CH2][adc_buff_inp]= ((ad_ch2.read_u16()>>4)&0xFFF);
//       Adc_buff[ADC_CH3][adc_buff_inp]= ((ad_ch3.read_u16()>>4)&0xFFF);
            Adc_buff[ADC_CH1][adc_buff_inp] = adc_CH1_now = 
              (((st_adc_sample_ave[ADC_CH1].sample_Add - st_adc_sample_ave[ADC_CH1].sample_Max - st_adc_sample_ave[ADC_CH1].sample_Min)/2) &0xFFF);
            Adc_buff[ADC_CH2][adc_buff_inp] = 
                (((st_adc_sample_ave[ADC_CH2].sample_Add - st_adc_sample_ave[ADC_CH2].sample_Max - st_adc_sample_ave[ADC_CH2].sample_Min)/2)&0xFFF);
            Adc_buff[ADC_CH3][adc_buff_inp] = 
                (((st_adc_sample_ave[ADC_CH3].sample_Add - st_adc_sample_ave[ADC_CH3].sample_Max - st_adc_sample_ave[ADC_CH3].sample_Min)/2)&0xFFF);
            adc_buff_inp = ((adc_buff_inp + 1) % ADC_BUFF_SIZE);
            ADC_ave_Init();
            i_ret = 1;
        }
        return(i_ret);
}
void ADC_Interrupt() {
int i_inp_ret;
     led2 = 1;
   if(adc_buff_inp == (ADC_BUFF_SIZE-1)){
        ADC_Count1Block++;
    }
    ADC_Count1++;
//#define ActiveMode_ADC_Sample_Busy  2  //
//int i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
    if(i_adc_ActiveMode_status == ActiveMode_ADC_Sample_Busy){      
        if (((adc_buff_inp + 1) % ADC_BUFF_SIZE) == adc_buff_out) {
            ADC_Stop();
        }
        else{
           i_inp_ret = ADC_Inp3CH();
       }
    }
    else if (i_adc_ActiveMode_status == ActiveMode_ADC_Sample_Ready){
//#define ADC_TRIGGER_READY   0    //Trigger Mode Ready :Trigger Wait & No Data Send
//#define ADC_TRIGGER_BUSY    1    //Trigger Mode Busy  :Trigger Detected & Sample Data Send
//#define ADC_TRIGGER_END     2    //Trigger Mode END  :Sample End & Data Send Done Wait
//int i_adc_Trigger_Sample_Status = ADC_TRIGGER_READY;
//int i_adc_Sample_Total_Count = 0;
//#define ADC_TRIGGER_START_ENABLE
//#define ADC_TRIGGER__START_READY
//bool b_Trigger_Start_sendFlag = ADC_TRIGGER__START_READY;
//#define ADC_PULSE_END_ENABLE
//#define ADC_PULSE_END_READY
//bool b_Trigger_EndFlag = ADC_PULSE_END_READY;
//
        switch(i_adc_Trigger_Sample_Status){
            case ADC_TRIGGER_READY:
                adc_buff_out = adc_buff_inp;
                if(ADC_Inp3CH()== 1) {
                   if(adc_CH1_now >= st_adc_mode_param.us_trigger_level){    // Trigger Point Detect
                       adc_buff_out = (adc_buff_inp + (ADC_BUFF_SIZE - st_adc_mode_param.i_pre_trig_point - 1)) % ADC_BUFF_SIZE;
                       i_adc_Trigger_Sample_Status = ADC_TRIGGER_BUSY;
                        i_adc_Sample_Total_Count = st_adc_mode_param.i_pre_trig_point;
                        i_adc_Sample_Total_Time = 0;
                        b_Trigger_Start_sendFlag = ADC_TRIGGER_START_ENABLE;
                        i_adc_Waveform_count++;
                        i_adc_trigger_end_count = st_adc_mode_param.i_pulse_end_time;
                    }
                }
                break;
            case ADC_TRIGGER_BUSY:
                if (((adc_buff_inp + 1) % ADC_BUFF_SIZE) == adc_buff_out) {
                    i_adc_Trigger_Sample_Status = ADC_TRIGGER_END;
                    b_Trigger_EndFlag = ADC_PULSE_END_ENABLE;
                }
                else{
                    if(ADC_Inp3CH()== 1){
                        i_adc_Sample_Total_Count++;
                        if(adc_CH1_now >= st_adc_mode_param.us_trigger_level){
                            i_adc_trigger_end_count = st_adc_mode_param.i_pulse_end_time;   // Pulse End Detect Reset
                        }
                        else{
                            if(i_adc_trigger_end_count == 0){
                                i_adc_Trigger_Sample_Status = ADC_TRIGGER_END;
                                b_Trigger_EndFlag = ADC_PULSE_END_ENABLE;
                            }
                        }
                    }
                }
                break;
            case ADC_TRIGGER_END:  // Data Sample Wait for Data Translate Complete
                if(adc_buff_out == adc_buff_inp){
                    i_adc_Trigger_Sample_Status = ADC_TRIGGER_READY;
                }
                break;
        }
    }
    led2 = 0;

}

void ADC_Stop() {
    ADC_Timer.detach();
    t.stop();
    led1=0;
}
//-------------------------------------------------------//
//    ADC Measurement Parameter Initial Set                          //
// 2013.08.14 H.Tsunemoto
//typedef struct  st_adc_param{
//    int   i_sample_interval; // DAC Output Pattern
//    float f_trigger_level;
//    unsigned short us_trigger_level;    // (3.3f/1023) * f_trigger_level (Image)
//    int i_pre_trig_point;
//    int i_pulse_end_time;
//}ST_ADC_PARAM;
//
//ST_ADC_PARAM st_adc_mode_param;
//-------------------------------------------------------//
void adc_param_init()
{
    st_adc_mode_param.i_sample_interval = const_ADC_Param_Default.i_sample_interval;
    st_adc_mode_param.f_trigger_level = const_ADC_Param_Default.f_trigger_level;
    st_adc_mode_param.us_trigger_level = const_ADC_Param_Default.us_trigger_level;
    st_adc_mode_param.i_pre_trig_point = const_ADC_Param_Default.i_pre_trig_point;
    st_adc_mode_param.i_pulse_end_time = const_ADC_Param_Default.i_pulse_end_time;
}
///////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------//
//-----    DAC Control Function 
//  H.Tsunemoto Scince 2013.08.09   
//    int i_pattern; // DAC Output Pattern
//    float f_pulse_high;
//    float f_pulse_low;
//    int i_pulse_width;
//    int i_pulse_interval;
//    int i_Total_time;    
//
//------------------------------------------------------------------------------//
//-------------------------------------------------------//
//    DAC Parameter Initial Set                          //
// 2013.08.09 H.Tsunemoto
//-------------------------------------------------------//
void dac1_param_init()
{
 int i;
 for (i=0;i<DAC1_PATTERN_MAX;i++){
    st_dac1_param[i].i_pattern = const_DAC1_Default[i].i_pattern;
    st_dac1_param[i].f_pulse_high = const_DAC1_Default[i].f_pulse_high;
    st_dac1_param[i].f_pulse_low = const_DAC1_Default[i].f_pulse_low;
    st_dac1_param[i].i_pulse_width = const_DAC1_Default[i].i_pulse_width;
    st_dac1_param[i].i_pulse_interval = const_DAC1_Default[i].i_pulse_interval;
    st_dac1_param[i].i_Total_time = const_DAC1_Default[i].i_Total_time;
 }
 
}
//------------------------------------------------------------------------//
//  Timer Interrupt Routine
//i_dac1_active_status
//#define DAC1_ACT_0_READY 0  // NO Active
//#define DAC1_ACT_1_START 1  // START Command Input
//#define DAC1_ACT_2_OUTPUT_BUSY // PULSE PATTERN ACTIVE  
//
//int i_dac1_pulse_act = DAC1_PULSE_ACT_INTERVAL;
//#define DAC1_PULSE_ACT_INTERVAL 0
//#define DAC1_PULSE_ACT_UP 1
//#define DAC1_PULSE_ACT_DOWN 2
//Global Parameter
// int i_dac1_active_count; //OUTPUT_WAVE TOTAL COUNT 0-500S:0-500000(0x7A120)
// int i_dac1_pulse_count;     //OUTPUT PULSE COUNT
//#define DAC1_PATTERN_1_SINGLE_PULSE 0
//#define DAC1_PATTERN_2_PULSE 1
//#define DAC1_PATTERN_3_TRIANGLE 2
//
//------------------------------------------------------------------------//
extern "C" void TIMER0_IRQHandler (void)
{
    if((LPC_TIM0->IR & 0x01) == 0x01)   // if MR0 interrupt, proceed
    {
        LPC_TIM0->IR |= 1 << 0;         // Clear MR0 interrupt flag
        timer_count++;                  //increment timer_count
        if(timer_count >= 10000){
            timer_count = 0;
            timer_1Sec++;
        }
        // ---  for ADC Sample End Check  ----//
        if( i_adc_trigger_end_count > 0){
            i_adc_trigger_end_count--;
            i_adc_Sample_Total_Time++;
        }
        
        //-- DAC Control --//
        switch(i_dac1_active_status){
            case DAC1_ACT_0_READY:
            led4=0;
                f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_low;
                dac_output.write(f_Dac1_volt);                                  //DAC Output 
                               // sprintf(tx_line,"DAC:%1d,%3x\r\n",i_dac1_pattern_now,st_dac1_param[i_dac1_pattern_now].i_pulse_low);
                               // send_line();
                break;
            case DAC1_ACT_1_START:
                led4=1;
                i_dac1_active_count = st_dac1_param[i_dac1_pattern_now].i_Total_time;
                i_dac1_pulse_act = DAC1_PULSE_ACT_UP;
                if(st_dac1_param[i_dac1_pattern_now].i_pattern == DAC1_PATTERN_3_TRIANGLE){
                    i_dac1_pulse_count = st_dac1_param[i_dac1_pattern_now].i_pulse_width/2;
                    f_Dac_Triangle_inc = ( st_dac1_param[i_dac1_pattern_now].f_pulse_high
                                            - st_dac1_param[i_dac1_pattern_now].f_pulse_low)
                                            / (float)(st_dac1_param[i_dac1_pattern_now].i_pulse_width/2);
                                          
                }
                else{
                    i_dac1_pulse_count = st_dac1_param[i_dac1_pattern_now].i_pulse_width;
                    f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_high;
                    dac_output.write(f_Dac1_volt);                                  //DAC Output 
                                // for Debug
                                //sprintf(tx_line,"DAC:%1d,%f\r\n",i_dac1_pattern_now,f_Dac1_volt*DAC1_FULL_VOLT_f);
                                //send_line();
                }
                i_dac1_active_status ++;  // = DAC1_ACT_2_OUTPUT_BUSY;
                break;
            case DAC1_ACT_2_OUTPUT_BUSY:
                // Wave Total COunt Check & if 0 Wave OutPut Done
                i_dac1_active_count--;
                if(i_dac1_active_count <= 0){
                    i_dac1_active_status = DAC1_ACT_0_READY;
                    f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_low;
                    dac_output.write(f_Dac1_volt);                                  //DAC Output
                                // for Debug
                                //sprintf(tx_line,"DAC:%1d,%f\r\n",i_dac1_pattern_now,f_Dac1_volt*DAC1_FULL_VOLT_f);
                                //send_line();
                    break;
                }
                // Pulse Count Down 
                if(st_dac1_param[i_dac1_pattern_now].i_pattern == DAC1_PATTERN_3_TRIANGLE){
                    if(i_dac1_pulse_act == DAC1_PULSE_ACT_UP){
                        f_Dac1_volt += f_Dac_Triangle_inc;
                        dac_output.write(f_Dac1_volt);                                  //DAC Output 
                    }
                    else if (i_dac1_pulse_act == DAC1_PULSE_ACT_DOWN){
                        f_Dac1_volt -= f_Dac_Triangle_inc;
                        dac_output.write(f_Dac1_volt);                                  //DAC Output 
                   }
                }
                i_dac1_pulse_count--;
                if( i_dac1_pulse_count <= 0){
                    switch(st_dac1_param[i_dac1_pattern_now].i_pattern){
                        case DAC1_PATTERN_1_SINGLE_PULSE:
                            break;
                        case DAC1_PATTERN_2_PULSE:
                            if(i_dac1_pulse_act == DAC1_PULSE_ACT_UP){
                                f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_low;
                                dac_output.write(f_Dac1_volt);                                  //DAC Output 
                                i_dac1_pulse_act = DAC1_PULSE_ACT_INTERVAL;
                                i_dac1_pulse_count = st_dac1_param[i_dac1_pattern_now].i_pulse_interval;
                            }
                            else {
                                f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_high;
                                dac_output.write(f_Dac1_volt);                                  //DAC Output 
                                i_dac1_pulse_act = DAC1_PULSE_ACT_UP;
                                i_dac1_pulse_count = st_dac1_param[i_dac1_pattern_now].i_pulse_width;                        
                            }
                            break;
                        case DAC1_PATTERN_3_TRIANGLE:
                            if(i_dac1_pulse_act == DAC1_PULSE_ACT_UP){
                                f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_high;
                                dac_output.write(f_Dac1_volt);                                  //DAC Output 
                                i_dac1_pulse_act = DAC1_PULSE_ACT_DOWN;
                                i_dac1_pulse_count = st_dac1_param[i_dac1_pattern_now].i_pulse_width/2;
                            }
                            else if(i_dac1_pulse_act == DAC1_PULSE_ACT_DOWN){
                                f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_low;
                                dac_output.write(f_Dac1_volt);                                  //DAC Output 
                                i_dac1_pulse_act = DAC1_PULSE_ACT_INTERVAL;
                                i_dac1_pulse_count = st_dac1_param[i_dac1_pattern_now].i_pulse_interval;
                            }
                            else {
                                f_Dac1_volt = st_dac1_param[i_dac1_pattern_now].f_pulse_low;
                                dac_output.write(f_Dac1_volt);                                  //DAC Output 
                                i_dac1_pulse_act = DAC1_PULSE_ACT_UP;
                                i_dac1_pulse_count = st_dac1_param[i_dac1_pattern_now].i_pulse_width/2;                        
                            }
                            break;
                        default:
                            i_dac1_active_status = DAC1_ACT_0_READY;
                            break;
                    }
                }             
                break;
            default:
                break;
        }
    }
}
 
void timer0_init(void)
{
    LPC_SC->PCONP |=1<1;            //timer0 power on
    // 2013.08.09 H.Tsunemoto    100mSec => 0.1mSec Change
    //LPC_TIM0->MR0 = 2398000;        //100 msec
    LPC_TIM0->MR0 = 2398;        //0.1 msec

    LPC_TIM0->MCR = 3;              //interrupt and reset control
                                    //3 = Interrupt & reset timer0 on match
                                    //1 = Interrupt only, no reset of timer0
    NVIC_EnableIRQ(TIMER0_IRQn);    //enable timer0 interrupt
    LPC_TIM0->TCR = 1;              //enable Timer0
 //   pc.printf("Done timer_init\n\r");
}

//------------------------------------------------------------------//
//-----    Serial rx Commmand Input & Parameter Set Function   -----//
//  Tsunemoto Scince 2013.08.08                                     //
//------------------------------------------------------------------//
void Ser_Command_Input()
{
    int i_RecCharCount;
    bool b_CommadERR = 0;

    while(rx_cr_Rec != 0){
         // Read a line from the large rx buffer from rx interrupt routine
        i_RecCharCount = read_line();
        if(i_RecCharCount < 3){
            b_CommadERR = 1;
        }
        else{
            switch(rx_line[0]){
                // Header "A"  ADC Control Command
                case 'A':
                    switch(rx_line[1]){
                        case 'S':
                            if(rx_line[2] == '0'){
                                i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy;

                            }
                            else{
                                i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Ready;
                            }
                            Start_ADC();
                            break;
                        case 'E':
                            ADC_Stop();
                             break;
                        case 'R':
                            b_CommadERR= com_Check_AR(i_RecCharCount);
                             break;
                        case 'L':
                            b_CommadERR= com_Check_AL(i_RecCharCount);
                             break;
                        case 'P':
                            b_CommadERR= com_Check_AP(i_RecCharCount);
                             break;
                        case 'I':
                            b_CommadERR= com_Check_AI(i_RecCharCount);
                             break;
                        case '?':
                            com_ADC_Table_Param_Send();
                            break;
                        default:
                                b_CommadERR = 1;
                            break;
                    }
                    break;
                // Header "D"  DAC Control Command
                case 'D':
                    switch(rx_line[1]){
                        case 'S':   // 'DS'Start Command
                            if(rx_line[2]=='1'){
                                i_dac1_pattern_now = DAC1_PATERN_1;
                            }
                           else if(rx_line[2]=='2'){
                                i_dac1_pattern_now = DAC1_PATERN_2;
                           }
                            else{
                                i_dac1_pattern_now = DAC1_PATERN_0;
                            }
                             i_dac1_active_status = DAC1_ACT_1_START;
                            break;
                        case 'E':   // 'DE'Active MOde Stop (End)
                            i_dac1_active_status = DAC1_ACT_0_READY;
                            break;
                        case 'M':   // 'DM' DAC Mode Set Single/Pulse/Triangle
                            b_CommadERR= com_Check_DM(i_RecCharCount);
                            break;
                        case 'H':   // 'DH' Pulse High Level[V] Set
                            b_CommadERR= com_Check_DH(i_RecCharCount);
                            break;
                        case 'L':   // 'DL' Pulse Low Level [V]Set
                            b_CommadERR= com_Check_DL(i_RecCharCount);
                            break;
                        case 'P':   //  'DP' Pulse Width [mSec]
                            b_CommadERR= com_Check_DP(i_RecCharCount);
                            break;
                        case 'I':    //  'DI' Pulse Interval [mSec]
                            b_CommadERR= com_Check_DI(i_RecCharCount);
                            break;
                        case 'W':    //  'DW' Total Pattern Width [Sec]
                            b_CommadERR= com_Check_DW(i_RecCharCount);
                            break;
                        case '?':   // Parameter Query
                            com_Table_Param_Send();
                            break;
                        default:
                            b_CommadERR = 1;
                             break;
                    }
                    break;
                case 'T':  // "T?" Timer Interrupt Counter Repry
                    if (rx_line[1]=='?'){
                        sprintf(tx_line,"Timer=%d[S}+%d[x0.1mSec] \r\n",timer_1Sec,timer_count); 
                        // Copy tx line buffer to large tx buffer for tx interrupt routine
                        send_line();
 
                    }
                    else if(rx_line[1]=='C'){
                        timer_1Sec = timer_count = 0;
                    }
                    else{
                        b_CommadERR = 1;
                    }
                    break;
                    
                   
                default:
                    b_CommadERR = 1;
                    break;
                
            }
        }  
        if(b_CommadERR == 0){
                sprintf(tx_line,"ACK%d \r\n",rx_cr_Rec); 
                // Copy tx line buffer to large tx buffer for tx interrupt routine
                send_line();
        }
        else{
                sprintf(tx_line,"ERR%d \r\n",rx_cr_Rec); 
                // Copy tx line buffer to large tx buffer for tx interrupt routine
                send_line();
        }
        rx_cr_Rec--;
          
    }
}
//////////////////////////////////////////////////////////////////////////////////
//------------    Command Check & Set Function ---------------------------------//
//  Input :i_RecCharCount :Command Stringth Length                              //
//         rx_line[80] :(Global) Rec Data Stringth                              //
//  Return :bool b_CommadERR  0= ACK                                            //
//                            1= ERR                                            //
//////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------------------//
//  ADC No.1  "ARxx.x  Pulse Mode Pulse Interval Set                              //
//#define ADC_SAMPLE_RATE_MIN  5
//#define ADC_SAMPLE_RATE_MAX  20000
//int st_adc_mode_param.i_sample_interval = 200;  // ADC Sample Rate 5 - 20000(20.0mSec)
//------------------------------------------------------------------------------//
bool com_Check_AR(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
char *pt_comRec;

    if(i_RecCharCount < 3){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[2];
        f_num = atof(pt_comRec);
        if((f_num >= ADC_SAMPLE_RATE_MIN_f ) && (f_num <= ADC_SAMPLE_RATE_MAX_f)){
                 st_adc_mode_param.i_sample_interval = (int)( f_num * 1000.0f + 0.5f) ;
        }
        else{
            b_CommadERR = 1;
        }
        
   }
    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
// ADC No.2 "ALx.xxx" ADC Trigger Limit Level 0.00-3.3V
//------------------------------------------------------------------------------//
bool com_Check_AL(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
char *pt_comRec;

    if(i_RecCharCount < 3){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[2];
        f_num = atof(pt_comRec);
        if((f_num >= 0) && (f_num <= 3.3000f)){
            st_adc_mode_param.f_trigger_level = f_num;
            st_adc_mode_param.us_trigger_level =(int)((f_num/(DAC1_FULL_VOLT_f / 4095.0f))+0.5f);
        }
        else{
            b_CommadERR = 1;
        }
    }
    return(b_CommadERR);
}
//------------------------------------------------------------------------------//
// ADC No.3 "APxx"  ADC PreTrigger Send Data Point
//#define ADC_PRE_TRIG_MIN 0
//#define ADC_PRE_TRIG_MAX 100
//------------------------------------------------------------------------------//
bool com_Check_AP(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
char *pt_comRec;

    if(i_RecCharCount < 3){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[2];
        f_num = atof(pt_comRec);
        if((f_num >= ADC_PRE_TRIG_MIN ) && (f_num <= ADC_PRE_TRIG_MAX)){
                 st_adc_mode_param.i_pre_trig_point = (int)( f_num + 0.5f) ;
        }
        else{
            b_CommadERR = 1;
        }
        
   }
    return(b_CommadERR);

}
//------------------------------------------------------------------------------//
// ADC No.4 "AIx.xxx" ADC Pulse End Point Check Time
//#define ADC_PULSE_END_MIN_f   0.1f  //0.1Sec
//#define ADC_PULSE_END_MAX_f   5.0f  //5.0Sec
//------------------------------------------------------------------------------//
bool com_Check_AI(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
char *pt_comRec;

    if(i_RecCharCount < 3){
        b_CommadERR = 1;
    } 
    else{
        pt_comRec = (char *)&rx_line[2];
        f_num = atof(pt_comRec);
        if((f_num >= ADC_PULSE_END_MIN_f ) && (f_num <= ADC_PULSE_END_MAX_f)){
                 st_adc_mode_param.i_pulse_end_time = (int)( f_num * 10000.0f + 0.5f) ;
        }
        else{
            b_CommadERR = 1;
        }
        
   }
    return(b_CommadERR);
}
//------------------------------------------------------------------------------//
//  ADC No.5  "A?"  DAC Parameter Repry                                          //
//typedef struct  st_adc_param{
//    int   i_sample_interval; // DAC Output Pattern
//    float f_trigger_level;
//    us_trigger_level;
//    int i_pre_trig_point;
//    int i_pulse_end_time;
//}ST_ADC_PARAM;
//
//ST_ADC_PARAM st_adc_mode_param;
//
//------------------------------------------------------------------------------//
void com_ADC_Table_Param_Send()
{
float f_num;

        f_num = ((float)st_adc_mode_param.i_sample_interval + 0.5f)/1000.0f;
        sprintf(tx_line,"AR%2.3f[mSec]\r\n",f_num);
        send_line();
        f_num = st_adc_mode_param.f_trigger_level;
        sprintf(tx_line,"AL%1.3f[V]:(0x%03x)\r\n",f_num,st_adc_mode_param.us_trigger_level);
        send_line();
        sprintf(tx_line,"AP%d[Sample]\r\n",st_adc_mode_param.i_pre_trig_point);
        send_line();
        f_num = ((float)st_adc_mode_param.i_pulse_end_time + 0.5f)/10000.0f;
        sprintf(tx_line,"AI%1.3f[Sec]\r\n",f_num);
        send_line();
// for Debug
        sprintf(tx_line,"ADC Sample Count = %d,BuffLoop=%d\r\n",ADC_Count1,ADC_Count1Block);
        send_line();
//
// Ative Mode Status Controll
//#define ActiveMode_ADC_Sample_Stop 0
//#define ActiveMode_ADC_Sample_Ready 1  // 
//#define ActiveMode_ADC_Sample_Busy  2  //
//int i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop;
// Trigger Mode Status Control
//#define ADC_TRIGGER_READY   0    //Trigger Mode Ready :Trigger Wait & No Data Send
//#define ADC_TRIGGER_BUSY    1    //Trigger Mode Busy  :Trigger Detected & Sample Data Send
//#define ADC_TRIGGER_END     2    //Trigger Mode END  :Sample End & Data Send Done Wait
//int i_adc_Trigger_Sample_Status = ADC_TRIGGER_READY;
//volatile unsigned short adc_CH1_now;
//int i_adc_trigger_end_count;
    switch(i_adc_ActiveMode_status){
        case ActiveMode_ADC_Sample_Stop:
            sprintf(tx_line,"ADC i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Stop\r\n");
            break;
        case ActiveMode_ADC_Sample_Ready:
            sprintf(tx_line,"ADC i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Ready\r\n");
            break;
        case ActiveMode_ADC_Sample_Busy:
            sprintf(tx_line,"ADC i_adc_ActiveMode_status = ActiveMode_ADC_Sample_Busy\r\n");
            break;
    }
    send_line();
    switch(i_adc_Trigger_Sample_Status){
        case ADC_TRIGGER_READY:
            sprintf(tx_line,"ADC i_adc_Trigger_Sample_Status = ADC_TRIGGER_READY\r\n");
            break;
        case ADC_TRIGGER_BUSY:
            sprintf(tx_line,"ADC i_adc_Trigger_Sample_Status = ADC_TRIGGER_BUSY\r\n");
            break;
        case ADC_TRIGGER_END:
            sprintf(tx_line,"ADC i_adc_Trigger_Sample_Status = ADC_TRIGGER_END\r\n");
            break;
    }
    send_line();
        sprintf(tx_line,"ADC input level:%03x i_adc_trigger_end_count = %d\r\n",adc_CH1_now,i_adc_trigger_end_count);
        send_line();


}


//------------------------------------------------------------------------------//
//  DAC_No.1  "DMn:xx (SINGLE/PULSE/TRIANGLE)                                       //
//------------------------------------------------------------------------------//
bool com_Check_DM(int i_RecCharCount)
{
 bool b_CommadERR=0;
 int i_work;
    if(i_RecCharCount < 7){
        b_CommadERR = 1;
     }
    if(rx_line[3]==':'){
        if((rx_line[4]=='S') & (rx_line[5]=='I')){
            i_work = DAC1_PATTERN_1_SINGLE_PULSE;
        }
        else if ((rx_line[4]=='P') & (rx_line[5]=='U')){
            i_work = DAC1_PATTERN_2_PULSE;
        }
        else if((rx_line[4]=='T') & (rx_line[5]=='R')){
            i_work = DAC1_PATTERN_3_TRIANGLE;
        }
        else{
            b_CommadERR = 1;
            return(b_CommadERR);
        }
        switch(rx_line[2]){
            case '0':
                st_dac1_param[0].i_pattern = i_work;
                break;
            case '1':
                st_dac1_param[1].i_pattern = i_work;
                break;
            case '2':
                st_dac1_param[2].i_pattern = i_work;
                break;
            default:
                b_CommadERR = 1;
                break;
        }
    }
    else{
        b_CommadERR = 1;
    }
    return(b_CommadERR);
}
//------------------------------------------------------------------------------//
//  DAC_No.2  "DHn:xx.x  Pulse High Level Volt Set  (0.000 - 3.300[V])               //
//------------------------------------------------------------------------------//
bool com_Check_DH(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
char *pt_comRec;

    //sprintf(tx_line,"DH?? \r\n"); 
    //strcpy((char *)rx_line[4],tx_line);
    //send_line();
   if(i_RecCharCount < 6){
        b_CommadERR = 1;
    } 
    else{
        if(rx_line[3]==':'){
            pt_comRec = (char *)&rx_line[4];
            f_num = atof(pt_comRec);
            if((f_num >= 0) && (f_num <= 3.3000f)){
                f_num = f_num/DAC1_FULL_VOLT_f;
                switch(rx_line[2]){
                    case '0':
                        st_dac1_param[0].f_pulse_high = f_num;
                        break;
                    case '1':
                        st_dac1_param[1].f_pulse_high = f_num;
                        break;
                    case '2':
                        st_dac1_param[2].f_pulse_high = f_num;
                        break;
               
                    default:
                        b_CommadERR = 1;
                        break;
                }
            }
            else{
                b_CommadERR = 1;
            }
        }
        else{
            b_CommadERR = 1;
        }
     }
    return(b_CommadERR);
}
//------------------------------------------------------------------------------//
//  DAC_No.3  "DLn:xx.x  Pulse Low Level Volt Set   (0.000 - 3.300[V])              //
//------------------------------------------------------------------------------//
bool com_Check_DL(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
char *pt_comRec;

    if(i_RecCharCount < 6){
        b_CommadERR = 1;
    } 
    else{
        if(rx_line[3]==':'){
            pt_comRec = (char *)&rx_line[4];
            f_num = atof(pt_comRec);
            if((f_num >= 0) && (f_num <= 3.3000f)){
                f_num = f_num/DAC1_FULL_VOLT_f;
                switch(rx_line[2]){
                    case '0':
                        st_dac1_param[0].f_pulse_low = f_num;
                        break;
                    case '1':
                        st_dac1_param[1].f_pulse_low = f_num;
                        break;
                    case '2':
                        st_dac1_param[2].f_pulse_low = f_num;
                        break;
               
                    default:
                        b_CommadERR = 1;
                        break;
                }
            }
            else{
                b_CommadERR = 1;
            }
        }
        else{
            b_CommadERR = 1;
        }
     }
    return(b_CommadERR);
}
//------------------------------------------------------------------------------//
//  DAC_No.4  "DPn:xx.x  Pulse Mode Pulse Width Set   (0.1 - 2000.0[mSec])            //
//------------------------------------------------------------------------------//
bool com_Check_DP(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
int i_work;
char *pt_comRec;

    if(i_RecCharCount < 6){
        b_CommadERR = 1;
    } 
    else{
        if(rx_line[3]==':'){
            pt_comRec = (char *)&rx_line[4];
            f_num = atof(pt_comRec);
            if((f_num >= 0.1f) && (f_num <= DAC1_PULSE_INT_MAX_f)){
                i_work = (int)(f_num*10.0f+0.5f);
                switch(rx_line[2]){
                    case '0':
                        st_dac1_param[0].i_pulse_width = i_work;
                        break;
                    case '1':
                        st_dac1_param[1].i_pulse_width = i_work;
                        break;
                    case '2':
                        st_dac1_param[2].i_pulse_width = i_work;
                        break;
               
                    default:
                        b_CommadERR = 1;
                        break;
                }
            }
            else{
                b_CommadERR = 1;
            }
        }
        else{
            b_CommadERR = 1;
        }
     }
    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  DAC_No.5  "DIn:xx.x  Pulse Mode Pulse Interval Set                              //
//------------------------------------------------------------------------------//
bool com_Check_DI(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
int i_work;
char *pt_comRec;

    if(i_RecCharCount < 6){
        b_CommadERR = 1;
    } 
    else{
        if(rx_line[3]==':'){
            pt_comRec = (char *)&rx_line[4];
            f_num = atof(pt_comRec);
            if((f_num >= 0.1f) && (f_num <= DAC1_PULSE_INT_MAX_f)){
                i_work = (int)(f_num*10.0f+0.5f);
                switch(rx_line[2]){
                    case '0':
                        st_dac1_param[0].i_pulse_interval = i_work;
                        break;
                    case '1':
                        st_dac1_param[1].i_pulse_interval = i_work;
                        break;
                    case '2':
                        st_dac1_param[2].i_pulse_interval = i_work;
                        break;
               
                    default:
                        b_CommadERR = 1;
                        break;
                }
            }
            else{
                b_CommadERR = 1;
            }
        }
        else{
            b_CommadERR = 1;
        }
     }
    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  DAC_No.6  "DWn:xx.x  Wave Form Total Width Set                                 //
//------------------------------------------------------------------------------//
bool com_Check_DW(int i_RecCharCount)
{
bool b_CommadERR=0;
float f_num=0.00f;
int i_work;
char *pt_comRec;

    if(i_RecCharCount < 6){
        b_CommadERR = 1;
    } 
    else{
        if(rx_line[3]==':'){
            pt_comRec = (char *)&rx_line[4];
            f_num = atof(pt_comRec);
            if((f_num >= 0.0001f) && (f_num <= DAC1_PULSE_TOTAL_TIME_MAX_f)){
                i_work = (int)(f_num*10000.0f+0.5f);
                switch(rx_line[2]){
                    case '0':
                        st_dac1_param[0].i_Total_time = i_work;
                        break;
                    case '1':
                        st_dac1_param[1].i_Total_time = i_work;
                        break;
                    case '2':
                        st_dac1_param[2].i_Total_time = i_work;
                        break;
               
                    default:
                        b_CommadERR = 1;
                        break;
                }
            }
            else{
                b_CommadERR = 1;
            }
        }
        else{
            b_CommadERR = 1;
        }
     }
    return(b_CommadERR);
 }
//------------------------------------------------------------------------------//
//  DAC_No.7  "D?"  DAC Parameter RepryWave Form Total Width Set                                 //
//------------------------------------------------------------------------------//
void com_Table_Param_Send()
{
float f_num;
int i;

    for (i=0;i<DAC1_PATTERN_MAX;i++){
        sprintf(tx_line,"DAC Pattern Table:%d\r\n",i); 
        send_line();
        if (st_dac1_param[i].i_pattern == DAC1_PATTERN_1_SINGLE_PULSE){
            sprintf(tx_line,"DM%1d:SINGLE\r\n",i); 
        }
        else if (st_dac1_param[i].i_pattern == DAC1_PATTERN_2_PULSE){
            sprintf(tx_line,"DM%1d:PULSE\r\n",i);
        }
        else{
            sprintf(tx_line,"DM%1d:TRIANGLE\r\n",i);
        }
        send_line();
        f_num = st_dac1_param[i].f_pulse_high*DAC1_FULL_VOLT_f;
        sprintf(tx_line,"DH%1d:%1.3f[V]\r\n",i,f_num);
        send_line();
        f_num = st_dac1_param[i].f_pulse_low *DAC1_FULL_VOLT_f;
        sprintf(tx_line,"DL%1d:%1.3f[V]\r\n",i,f_num);
        send_line();
        f_num = ((float)st_dac1_param[i].i_pulse_width + 0.005) / 10.0f;;
        sprintf(tx_line,"DP%1d:%4.1f[mSec]\r\n",i,f_num);
        send_line();
        f_num = ((float)st_dac1_param[i].i_pulse_interval + 0.005)/10.0f;
        sprintf(tx_line,"DI%1d:%4.1f[mSec]\r\n",i,f_num);
        send_line();
        f_num = ((float)st_dac1_param[i].i_Total_time + 0.005)/10000.0f;
        sprintf(tx_line,"DW%1d:%1.4f[Sec]\r\n",i,f_num);
        send_line();
        sprintf(tx_line,"\r\n");
        send_line();
    }
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////


//------------------------------------------------------------------------------//
//------------------------------------------------------------------------------//
//-----    Serial tx/rx Communication  
//------------------------------------------------------------------------------//
// Copy tx line buffer to large tx buffer for tx interrupt routine
void send_line() {
    int i;
    char temp_char;
    bool empty;
    i = 0;
// Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (tx_line[i-1] != '\n')) {
// Wait if buffer full
        if (((tx_in + 1) % ser_buffer_size) == tx_out) {
// End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % ser_buffer_size) == tx_out) {
            }
// Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = tx_line[i];
        i++;
        tx_in = (tx_in + 1) % ser_buffer_size;
    }
    if (device.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % ser_buffer_size;
// Send first character to start tx interrupts, if stopped
        device.putc(temp_char);
    }
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}

// Read a line from the large rx buffer from rx interrupt routine
// 2013.08.08 H.Tsunemoto 
// Append Return Chear Number
int read_line(){
//void read_line() {
    int i;
    i = 0;
    // Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    // Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
    // Wait if buffer empty
        if (rx_in == rx_out) {
    // End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
    // Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % ser_buffer_size;
    }
    rx_line[i-1] = 0;
// End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return(i);
}

// Interupt Routine to read in data from serial port
void Rx_interrupt() {
    //led1=1;
// Loop just in case more than one character is in UART's receive FIFO buffer
// Stop if buffer full
    while ((device.readable()) || (((rx_in + 1) % ser_buffer_size) == rx_out)) {
        rx_buffer[rx_in] = device.getc();
// Uncomment to Echo to USB serial to watch data flow
//        monitor_device.putc(rx_buffer[rx_in]);
        //------- 2013.08.08 Tsunemoto ------------//
        // -- Char CR Rec Counter ----//
        if(rx_buffer[rx_in]== '\r'){
           //led2 = 1;
           rx_cr_Rec ++;
        }
        //----------------------------//
        rx_in = (rx_in + 1) % ser_buffer_size;
    }
    //led1=0;
    return;
}

// Interupt Routine to write out data to serial port
void Tx_interrupt() {
    //led2=1;
// Loop to fill more than one character in UART's transmit FIFO buffer
// Stop if buffer empty
    while ((device.writeable()) && (tx_in != tx_out)) {
        device.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % ser_buffer_size;
    }
    //led2=0;
    return;
}
//----------------------------------------------------------------------------------//
