//;2648 ;00 00000 0;168 ;001; 10043 c1;31 10;00 00;00 00;10 63;08 39;I; -012; 0002; 0104;\r\n
//;109  ;00 00000 0;123 ;011; 10008 e4;27 95;00 00;00 00;13 99;08 51;G; -068; -096; -192;
#ifndef CADENCE_H
#define CADENCE_H

#include "mbed.h"
#include <string>
DigitalOut led3(LED3);
class Cadence : public RawSerial{
    private:
    static const int DATAS_NUM = 75;
    
    protected:
    
    public:
    string strC,strV;
    char data[DATAS_NUM];
    string strData;
    int data_count, data_num;
    double cadence, voltage;
    Cadence(PinName tx, PinName rx, const char* name = NULL) : RawSerial(tx, rx){
        for(int i=0;i<DATAS_NUM;i++) data[i]= NULL;
        data_num=0;
        data_count=0;
        baud(115200);
        cadence=0;
        voltage=0;
    }
    int checkInt(const char c[]){
        for(int i = 0; i<strlen(c); i++){
            if( c[0] == '-' ) continue;
            if( c[i] - '0' > 9 || c[i] - '0' <0 ) return -1;
        }return 1;
    }
    void readData(){
      if(readable()){
        data_count = 0;
        for (int i = 0; i<DATAS_NUM; i++) data[i] = NULL;
        do{
            if(readable()) {
                data[data_count] = getc();
                if(data[data_count] != '\n') data_count++;
                led3 = !led3;
            }
        }while(data[data_count] != '\n' && data_count<DATAS_NUM);
        strData = data;
        if( int strlength = strData.length() > DATAS_NUM-4 ){
//            for(int i = 0; i<4; i++){
//                strC += data[data_count-6+i];
//                strV += data[data_count-43+i];
//            }
//            if( checkInt(strC) ) sscanf(strC,"%lf",&cadence);
//            if( checkInt(strV) ) sscanf(strV,"%lf",&voltage);

            switch (strData.length()){
                case DATAS_NUM-3 :
                    strData.erase(0,2);
                    break;
                case DATAS_NUM-2 :
                    strData.erase(0,3);
                    break;
                case DATAS_NUM-1 :
                    strData.erase(0,4);
                    break;
                case DATAS_NUM :
                    strData.erase(0,5);
            }
            strV = strData.substr(27,4);
            strC = strData.substr(64,4);
            if( checkInt( strV.c_str() ) ) sscanf(strV.c_str(),"%lf",&voltage);
            if( checkInt( strC.c_str() ) ) sscanf(strC.c_str(),"%lf",&cadence);
            
            cadence /= 6.0;
            voltage *= 0.001;
        }
      }
    }
};
#endif