#ifndef MBED_MX12_H
#define MBED_MX12_H

#include "mbed.h"

#define MX12_DATA_MAX_SIZE 256
#define MX12_MAX_MOTOR_COUNT 16

class MX12 {
public:
	enum Status {
		InstructionError,
		OverloadError,
		ChecksumError,
		RangeError,
		OverheatingError,
		AngleLimitError,
		InputVoltageError,
		Unknown,
		Ok
	};
	
	enum ParsingState {
		Header,
		Id,
		Length,
		Data,
		Checksum,
	};

	enum SerialState {
		Writing,
		Reading,
		Idling,
	};

	struct Frame {
		unsigned char motorId;
		unsigned char length;
		unsigned char data[MX12_DATA_MAX_SIZE];
		unsigned char valid;
	};

	struct StateContext {
		unsigned char headingCount;
		unsigned char dataCount;
		unsigned char checksum;
	};

	MX12(PinName tx, PinName rx, int baud=115200);
	
	void SetSpeed(unsigned char mot_id, float speed);
	char IsAvailable(void);
	void rw(unsigned char mot_id, char adress, char len, char *data);
	void PrintSerial();
	MX12::Status GetStatus(void);

private:
	UnbufferedSerial _mx12;
	MX12::ParsingState _pstate;
	MX12::SerialState _sstate;
	MX12::StateContext _scontext;
	MX12::Frame _current_frame;

	unsigned char _answer;
	unsigned char _stored_frame[MX12_DATA_MAX_SIZE];
	unsigned char _frame_pointer;

	void _ReadCallback();
};

#endif /* MBED_MX12_H */
