
#ifndef INA219_H
#define INA219_H
/** Simplified INA219 class, fork of https://developer.mbed.org/users/mazgch/code/INA219/ from Michael Ammann .
 * This class is using I2CR class https://developer.mbed.org/users/ShockSoc/code/I2CR/ which is set to pins p9 (SDA) and p10 (SCL)
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "INA219.h"
 * #include "INA219_reg.h"
 *
 * INA219 ina();
 * float rawValue;
 *
 * int main() {
 *     rawValue = ina.readRawReg(INA219_POWER);
 * }
 * @endcode

*/
#include "mbed.h"
#include "I2CR.h"

class INA219
{
public:
/**
 * Calling the INA219 calibrates the sensor registers
*/    
    INA219();
    /** Read raw value from register
     * @param reg adress of register definicions in INA219_reg.h
     * @returns raw float value
    */

    uint16_t readRawReg(uint8_t reg);

    /**
     * Read raw value from register
     * @param reg adress of register defined in INA219_reg.h
     * @param data data that you want to sent
    */
    void write_reg(uint8_t reg, uint8_t data);

private:

    I2CR i2cr;

    uint8_t dt[4];
   /**
    * Should be public with changable calibration values.
    * Calibration settings set to :
    * A0 i A1 to GND (adress for I2C communication 0x40)
    * - 320 mv range
    * - 16 V bus voltage
    * - 12 bit 128 samples current and bus voltage ADC resolution
    * - Shunt and bus voltage conntinious
    * - Calibration : 5400
   */
    void calibration();
};

#endif