#define INA219_ADDR_GG             (0x40 << 1)
#define INA219_ADDR_GV             (0x41 << 1)
#define INA219_ADDR_GA             (0x42 << 1)
#define INA219_ADDR_GL             (0x43 << 1)
#define INA219_ADDR_VG             (0x44 << 1)
#define INA219_ADDR_VV             (0x45 << 1)
#define INA219_ADDR_VA             (0x46 << 1)
#define INA219_ADDR_VL             (0x47 << 1)
#define INA219_ADDR_AG             (0x48 << 1)
#define INA219_ADDR_AV             (0x49 << 1)
#define INA219_ADDR_AA             (0x4a << 1)
#define INA219_ADDR_AL             (0x4b << 1)
#define INA219_ADDR_LG             (0x4c << 1)
#define INA219_ADDR_LV             (0x4d << 1)
#define INA219_ADDR_LA             (0x4e << 1)
#define INA219_ADDR_LL             (0x4f << 1)

/////////// REGISTER DEFINITION /////////////////
#define INA219_CONFIG              0x00
#define INA219_SHUNT_V             0x01
#define INA219_BUS_VOLT            0x02
#define INA219_POWER               0x03
#define INA219_CURRENT             0x04
#define INA219_CALBLATION          0x05

/////////// PARAMETER SETTING ///////////////////
// Set data into "shunt_register"
#define INA219_PAR_R_100MOHM       100
#define INA219_PAR_R_50MOHM        50
#define INA219_PAR_R_20MOHM        20
#define INA219_PAR_R_100MOHM       100
#define INA219_PAR_R_200MORM       200
#define INA219_PAR_R_MORM(x)       (x)
// Set data into "v_max"
#define INA219_PAR_V_16V           0
#define INA219_PAR_V_32V           1    // Default
// Set data into "gain"
#define INA219_PAR_G_40MV          0    // 400[mA] max if R=0.1[Ohm]
#define INA219_PAR_G_80MV          1
#define INA219_PAR_G_160MV         2
#define INA219_PAR_G_320MV         3    // Default
// Set data into "bus_adc_resolution"
#define INA219_PAR_B_9B_X1_84US    0x0
#define INA219_PAR_B_10B_X1_148US  0x1
#define INA219_PAR_B_11B_X1_276US  0x2
#define INA219_PAR_B_12B_X1_532US  0x3  // Default
#define INA219_PAR_B_12B_X2_1R06MS 0x9
#define INA219_PAR_B_12B_X4_2R13MS 0xa
#define INA219_PAR_B_12B_X8_4R26MS 0xb
#define INA219_PAR_B_12B_X16_8MS   0xc
#define INA219_PAR_B_12B_X32_17MS  0xd
#define INA219_PAR_B_12B_X64_34MS  0xe
#define INA219_PAR_B_12B_X128_68MS 0xf
// Set data into "shunt_adc_resolution"
#define INA219_PAR_S_9B_X1_84US    0x0
#define INA219_PAR_S_10B_X1_148US  0x1
#define INA219_PAR_S_11B_X1_276US  0x2
#define INA219_PAR_S_12B_X1_532US  0x3  // Default
#define INA219_PAR_S_12B_X2_1R06MS 0x9
#define INA219_PAR_S_12B_X4_2R13MS 0xa
#define INA219_PAR_S_12B_X8_4R26MS 0xb
#define INA219_PAR_S_12B_X16_8MS   0xc
#define INA219_PAR_S_12B_X32_17MS  0xd
#define INA219_PAR_S_12B_X64_34MS  0xe
#define INA219_PAR_S_12B_X128_68MS 0xf
// Set data into "mode"
#define INA219_PAR_M_PDWN          0
#define INA219_PAR_M_SHNT_TRG      1
#define INA219_PAR_M_BUS_TRG       2
#define INA219_PAR_M_SHNTBUS_TRG   3
#define INA219_PAR_M_ADC_OFF       4
#define INA219_PAR_M_SHNT_CONT     5
#define INA219_PAR_M_BUS_CONT      6
#define INA219_PAR_M_SHNTBUS_CONT  7  

#define INA219_CFG_RESET           (1UL << 15)

#define INA219_CFG_B32V            (1UL << 13)
#define INA219_CFG_B16V            (0UL << 13)

#define INA219_CFG_PGA_DIV_1       (0UL << 11)
#define INA219_CFG_PGA_DIV_2       (1UL << 11)
#define INA219_CFG_PGA_DIV_4       (2UL << 11)
#define INA219_CFG_PGA_DIV_8       (3UL << 11)

#define INA219_CFG_BADC            (0xf << 7)

#define INA219_CFG_SADC_9B_84U     (0x0 << 3)
#define INA219_CFG_SADC_10B_148U   (0x1 << 3)
#define INA219_CFG_SADC_11B_276U   (0x2 << 3)
#define INA219_CFG_SADC_12B_532U   (0x3 << 3)
#define INA219_CFG_SADC_2S_1R06M   (0x9 << 3)
#define INA219_CFG_SADC_4S_2R13M   (0xa << 3)
#define INA219_CFG_SADC_8S_4R26M   (0xb << 3)
#define INA219_CFG_SADC_16S_8R51M  (0xc << 3)
#define INA219_CFG_SADC_32S_17M    (0xd << 3)
#define INA219_CFG_SADC_64S_34M    (0xe << 3)
#define INA219_CFG_SADC_128S_68M   (0xf << 3)

#define INA219_CFG_MODE_PDWN       (0UL << 0)
#define INA219_CFG_MODE_SHNTTRG    (1UL << 0)
#define INA219_CFG_MODE_BUSTRG     (2UL << 0)
#define INA219_CFG_MODE_SBTRG      (3UL << 0)
#define INA219_CFG_MODE_ADC_OFF    (4UL << 0)
#define INA219_CFG_MODE_SHNT_CONT  (5UL << 0)
#define INA219_CFG_MODE_BUS_CONT   (6UL << 0)
#define INA219_CFG_MODE_SB_CONT    (7UL << 0)

#define INA219_PAR_M_ADC_OFF       4
#define INA219_PAR_M_SHNT_CONT     5
#define INA219_PAR_M_BUS_CONT      6
#define INA219_PAR_M_SHNTBUS_CONT  7    // Default