/** This is 
**
*/

#include "INA219_reg.h"
#include "INA219.h"
#include "I2CR.h"

INA219::INA219() {
calibration();    
}


void INA219::calibration(void) {
       
    uint16_t data = 0;
    
    data  = (INA219_PAR_V_16V & 0x01) << 13;
    data |= (INA219_PAR_G_320MV  & 0x03) << 11;
    data |= (INA219_PAR_B_12B_X128_68MS & 0x0f) << 6;
    data |= (INA219_PAR_S_12B_X128_68MS & 0x0f) << 3;
    data |= (INA219_PAR_M_SHNTBUS_CONT  & 0x07);
    
    dt[0] = INA219_CONFIG;
    dt[1] = data >> 8;    // MSB 1st
    dt[2] = data & 0xff;  // LSB 2nd
    i2cr.write(INA219_ADDR_GG, (char *)dt, 3);
    
    dt[0] = INA219_CALBLATION;
    dt[1] =  5400 >> 8;    // MSB 1st
    dt[2] =  5400 & 0xff;  // LSB 2nd
    i2cr.write(INA219_ADDR_GG, (char *)dt, 3);
};

uint16_t INA219::readRawReg(uint8_t reg = 0x04)
{
    dt[0] = reg;
    i2cr.write(INA219_ADDR_GG, (char *)dt, 1);
    i2cr.read(INA219_ADDR_GG, (char *)dt, 2);
    int16_t data = (dt[0] << 8) | dt[1];
    return data ;
}

void INA219::write_reg(uint8_t reg, uint8_t data)
{
    dt[0] = reg;
    dt[1] = data;
    i2cr.write(INA219_ADDR_GG, (char *)dt, 2);
}
