#include "mbed.h"
#include "CharLcd4bit.h"

// LEDのポート宣言
DigitalOut Led(LED1);

// LCDのライブラリ、LCDポート宣言
CharLcd4bit lcd(A0, A1, A2, D4, D5, D6, D7);

char message1[][16] = {
    "Hello!",
    "How are you?",
    "I am fine.",
    "And you?",
    "I am fine too.",
    ""
};

char message2[][16] = {
    ">             ",
    "->            ",
    "-->           ",
    "--->          ",
    "---->         ",
    "----->        ",
    "------>       ",
    "------->      ",
    "-------->     ",
    "--------->    ",
    "---------->   ",
    "----------->  ",
    "------------> ",
    "------------->"
};

int main() {
    int message1Count = sizeof(message1) / 16;
    int message2Count = sizeof(message2) / 16;
    int message1Index = 0;
    int message2Index = 0;
    
    // LCD初期化
    lcd.Initialize();

    lcd.WriteLine(1, "Waiting");
    lcd.WriteLine(2, "  for Initialize...");
    wait(3);
    
    // 表示クリア
    lcd.Clear();
    wait(3);    
    
    while(1) {        
        Led = 0;
        lcd.SetPosition(2, 15);
        lcd.WriteChar(' ');
        wait_ms(500);

        lcd.WriteLine(1, message1[message1Index]);
        message1Index++;
        if(message1Index >= message1Count) message1Index = 0;

        Led = 1;
        lcd.SetPosition(2, 15);
        lcd.WriteChar(0xA5);
        wait_ms(500);
        
        lcd.SetPosition(2, 0);
        lcd.WriteStr(message2[message2Index]);
        message2Index++;
        if(message2Index >= message2Count) message2Index = 0;
    }
}