#ifndef _CharLcd4bit_H
#define _CharLcd4bit_H

#include "mbed.h"

/** 1602LCD表示クラス 4bitモード */
class CharLcd4bit
{
    public:
        /** コンストラクタ */
        CharLcd4bit(
            PinName rs,
            PinName rw,
            PinName e,
            PinName d4,
            PinName d5,
            PinName d6,
            PinName d7);
    
        /** LCD初期化 */
        void Initialize();
    
        /** 1行出力 (1行の文字数満たない場合は空白で埋める)
        *
        * @param int line      : ライン番号
        * @param char *str     : 文字列
        */
        void WriteLine(int line, char *str);
        
        /** 文字列出力
        *
        * @param char *str              : 文字列
        */
        void WriteStr(char *str);
        
        /** 1文字出力
        *
        * @param char c        : 文字
        */
        void WriteChar(char c);
        
        /** 文字位置指定
        *
        * @param int line      : ライン番号
        * @param int position  : 文字位置
        */
        void SetPosition(int line, int position);
        
        /** 表示クリア */
        void Clear();
        
    private:
        void lcd8(char c, bool isData);
        void lcd4(char data);
        
        DigitalOut RS;
        DigitalOut RW;
        DigitalOut E;
        DigitalOut DB4;
        DigitalOut DB5;
        DigitalOut DB6;
        DigitalOut DB7;
};

#endif // _CharLcd4bit_H