#include "CharLcd4bit.h"

#define WAIT_E()            wait_ms(1)
#define CHAR_MAX_PER_LINE   16
#define LINE_MAX            2

/* コンストラクタ */
CharLcd4bit::CharLcd4bit(
    PinName rs,
    PinName rw,
    PinName e,
    PinName db4,
    PinName db5,
    PinName db6,
    PinName db7) :
    RS(rs),
    RW(rw),
    E(e),
    DB4(db4),
    DB5(db5),
    DB6(db6),
    DB7(db7)
{
    
}

/* LCD初期化 */
void CharLcd4bit::Initialize(void)
{
    lcd8(0x03, false);//8bit mode
    lcd8(0x03, false);//8bit mode
    lcd8(0x03, false);//8bit mode
    lcd8(0x02, false);//4bit mode
    lcd4(0x08);//２行表示モード
    lcd4(0x0c);//表示設定
    lcd4(0x06);//entry mode
    lcd4(0x01);//clear
}

/* 1行出力 */
void CharLcd4bit::WriteLine(int line, char *str)
{
    char *ad=0;
    
    // 文字位置指定
    SetPosition(line, 0);

    ad = str;
    for(int i = 0; i < CHAR_MAX_PER_LINE; i++)
    {
        if(*ad)
        {
            WriteChar(*ad);
            ad++;
        }
        else
        {
            // 文字数が足りない時は空白で埋める
            WriteChar(' ');
        }
    }
}

/* 1行出力 */
void CharLcd4bit::WriteStr(char *str)
{
    char *ad=0;

    ad = str;
    while(*ad)
    {
        WriteChar(*ad);
        ad++;
    }
}

/* 1文字出力 */
void CharLcd4bit::WriteChar(char c)
{
    lcd8(c >> 4, true);
    lcd8(c, true);
}

/* 文字位置指定 */
void CharLcd4bit::SetPosition(int line, int position)
{
    if(line==1)
        lcd4(0x80 + position); /*1行目*/
    else if(line==2)
        lcd4(0xc0 + position); /*2行目*/
}

void CharLcd4bit::Clear()
{
    lcd4(0x01);
}

/* 8bitモード出力 -> 4bit接続に変換して出力 */
void CharLcd4bit::lcd8(char c, bool isData)
{
    char temp = c;
    
    DB4 = temp & 0x01;
    temp = temp >> 1;

    DB5 = temp & 0x01;
    temp = temp >> 1;

    DB6 = temp & 0x01;
    temp = temp >> 1;

    DB7 = temp & 0x01;
    
    if(isData) RS = 1;
    E=1;
    WAIT_E();
    E=0;
    if(isData) RS = 0;
    WAIT_E();
}

/* 4bitモード出力 */
void CharLcd4bit::lcd4(char data)
{
    lcd8(data >> 4, false);
    lcd8(data, false);
}