#include "mbed.h"
#include <stdio.h>
#include "LSM9DS1.h"
#include "VL53L0X.h"

DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);
DigitalOut shdn(p26);

LSM9DS1 lol(p9, p10, 0xD6, 0x3C);
I2C i2c(p28, p27);
VL53L0X lidar(&i2c);

int main() 
{
    float tempC;
    shdn = 0; //must reset sensor for an mbed reset to work
    wait(0.1);
    shdn = 1;
    wait(0.1);
    lol.begin();
    if (!lol.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    lol.calibrate();
    
    //loop taking and printing distance
    while (1) 
    {
        lol.readTemp();
        lol.readMag();
        lol.readGyro();
        
        //pc.printf("%d %d %d %d %d %d %d %d %d\n\r", lol.calcGyro(lol.gx), lol.calcGyro(lol.gy), lol.calcGyro(lol.gz), lol.ax, lol.ay, lol.az, lol.mx, lol.my, lol.mz);
        //pc.printf("%d %d %d\n\r", lol.calcGyro(lol.gx), lol.calcGyro(lol.gy), lol.calcGyro(lol.gz));
        pc.printf("gyro: %d %d %d\n\r", lol.gx, lol.gy, lol.gz);
        pc.printf("accel: %d %d %d\n\r", lol.ax, lol.ay, lol.az);
        pc.printf("mag: %d %d %d\n\n\r", lol.mx, lol.my, lol.mz);
        myled = 1;
        wait(2);
        myled = 0;
        wait(2);
//        tempC = myTMP36;
//        pc.printf("Float operator overloading avoids .read(): T=%5.2F C \n\r", tempC);
//        pc.printf("A Printf arg needs a float type convert: T=%5.2F C \n\r", float(myTMP36));
//        pc.printf("Or Use .read() instead: T=%5.2F C \n\r\n\r", myTMP36.read());
//        wait(.5);
        
    }
    
}
