#include "mbed.h"
#include "uLCD_4DGL.h"
#include "segment_display.h"
// Include header files for missile command project
#include "globals.h"
#include "city_landscape_public.h"
#include "missile_public.h"
#include "player.h"
// Platform initialization
Serial pc(USBTX,USBRX);
DigitalIn left_pb(p23);
DigitalIn right_pb(p21);
DigitalIn fire_pb(p22);
DigitalIn gameOn(p19);
DigitalOut gameWin(p20);
uLCD_4DGL uLCD(p28,p27,p29);
//Initialize variables
PLAYER_MISSILE missileArr [5];
PLAYER player;
int radius = 10;
int missileCount = 5;
int  d, w, l;
int s = 0;
int cityCount = 4;
int lives = 3;
//draw the anti missile
void player_missile_draw(PLAYER_MISSILE missile, int color)
{
    int init_x, init_y, current_x, current_y;
    init_x = missile.source_x;
    init_y = 96;
    current_x = init_x;
    current_y = missile.y;
    uLCD.line(init_x, init_y, current_x, current_y, color);
}
// create the anti missile
void player_missile_create(void)
{
    int z;
    for(z=0; z<5; z++) {
        if(missileArr[z].status == PLAYER_MISSILE_DEACTIVE) {
            missileArr[z].y = 96;
            //each missile has its own tick

            //set a random source for the missile
            missileArr[z].source_x = player.x + 5;
            //set a random target for the missile
            missileArr[z].origin_y = 96;
            //the missile starts at its source

            missileArr[z].status = PLAYER_MISSILE_ACTIVE;
            break;
        }
    }
}

void player_missile_update_position(void)
{
    int b;
    //controls how fast the missile will move
    //delta_x and delta_y account for the slope of the missile
    double delta_y;
    for(b=0; b<5; b++) {
        if(missileArr[b].status == PLAYER_MISSILE_ACTIVE) {
            // update missile position
            delta_y = 5;
            missileArr[b].y = missileArr[b].y - delta_y;
            // draw missile
            player_missile_draw(missileArr[b], PLAYER_COLOR);
        }
        if(missileArr[b].y < 0) {
            player_missile_draw(missileArr[b], BLACK_COLOR );
            missileArr[b].status = PLAYER_MISSILE_DEACTIVE;
        } else if(missileArr[b].status == PLAYER_MISSILE_EXPLODED) {
            // clear the missile on the screen
            player_missile_draw(missileArr[b], BLACK_COLOR);
            // we have done with this missile, remove it from record
            missileArr[b].status = PLAYER_MISSILE_DEACTIVE;
            //resets the missile's internal tick
            missileCount = missileCount + 1;
        }
    }
}

void player_set_exploded(int index)
{
    // Error check
    ASSERT_P(index<MAX_NUM_MISSILE,ERROR_MISSILE_INDEX_UPDATE_STATUS);

    missileArr[index].status = PLAYER_MISSILE_EXPLODED;
    missileCount = missileCount + 1;
}


int main()
{
    gameWin = false;
    uLCD.locate(0, 0);
    //uLCD.printf("Lvl:", level());
    //uLCD.printf("Score: %2d", s);
    //uLCD.prinf("Missiles: ",
    //uLCD.printf("Lives: ",
    setup_sequence();
    seg_driver_initialize();
    // 2.show numbers
    int i;
    for(i=0; i<10; i++) {
        seg_driver(i);
        wait(0.2);
    }
    // Draw cities
    city_landscape_init(4);
    // Initialize the buttons
    left_pb.mode(PullUp);  // The variable left_pb will be zero when the pushbutton for moving the player left is pressed
    right_pb.mode(PullUp); // The variable rightt_pb will be zero when the pushbutton for moving the player right is pressed
    fire_pb.mode(PullUp);  //the variable fire_pb will be zero when the pushbutton for firing a missile is pressed

    ///Begin the game loop

    player.x = 60;
    player_draw(player.x,100);
    while(1) {
        if (gameOn==true) {
            //print Score and Lives
            uLCD.locate(0,0);
            uLCD.color(0x00FF00);
            uLCD.printf("Score: %2d \n", s);
            uLCD.printf("Lives: %2d" , lives);

            missileCount = 5;
            for(l = 0; l<5; l++) {
                if(missileArr[l].status == PLAYER_MISSILE_ACTIVE) {
                    missileCount = missileCount - 1;
                }
                seg_driver(missileCount);
            }
            missile_generator(); /// updates all incoming missiles on the screen
            if(left_pb == 0 && player.x>0) {
                //Move player left
                player_draw(player.x,100);
                player_delete(player.x,100);
                player.x = player.x - 10;
                player_draw(player.x,100);
            }
            if(right_pb == 0 && player.x<110) {
                //Move player right
                player_draw(player.x,100);
                player_delete(player.x,100);
                player.x = player.x + 10;
                player_draw(player.x,100);
            }
            if(fire_pb == 0) {
                player_missile_create();
            }
            player_missile_update_position();
            //missile-player collision
            for ( int p=0; p<5; p++) {
                MISSILE missile_record = missile_get_info(p);
                int q,w, r, t;
                q = player.x + 10;
                w = 100;
                r = player.x;
                t = 96;
                if((missile_record.x > r & missile_record.x<q) & (missile_record.y<w & missile_record.y>t & (missile_record.status==MISSILE_ACTIVE))) {
                    lives -= 1;
                    missile_set_exploded(p);
                    wait(1);
                    if(lives == 0) {
                        gameover(s);
                        break;
                    }
                    for(int j=0; j<11; j=j+3) {
                        uLCD.circle(missile_record.x, missile_record.y, j, YELLOW_COLOR);
                        uLCD.circle(missile_record.x, missile_record.y, j, BLACK_COLOR);
                    }
                }
            }
            //missile-city collision
            for ( int e=0; e<5; e++) {
                MISSILE missile_record = missile_get_info(e);
                for (int d = 0; d<5; d++) {
                    CITY city_record = city_get_info(d);
                    int f, g, h, i;
                    f = city_record.x + city_record.width;
                    g = city_record.y - city_record.height;
                    h = city_record.x;
                    i = city_record.y;
                    if((missile_record.x > h & missile_record.x<f) & (missile_record.y<i & missile_record.y>g) & (city_record.status == EXIST)) {
                        for(int j=0; j<11; j=j+3) {
                            uLCD.circle(missile_record.x, missile_record.y, j, YELLOW_COLOR);
                            uLCD.circle(missile_record.x, missile_record.y, j, BLACK_COLOR);
                        }
                        missile_set_exploded(e);
                        city_destroy(d);
                        cityCount = cityCount -1;
                        if(cityCount == 0) {
                            gameover(s);
                        }
                        break;
                    }
                }
            }
            //missile-player_missile collision
            for(d=0; d<5; d++) {
                for(w=0; w<5; w++) {
                    MISSILE missile_record = missile_get_info(w);
                    double f;
                    f = (int)sqrt(pow((double)(missile_record.x-missileArr[d].source_x),2.0) +  pow((double)(missile_record.y-missileArr[d].y),2.0));

                    if((f<radius) && (missile_record.status == MISSILE_ACTIVE) && (missileArr[d].status== PLAYER_MISSILE_ACTIVE)) {
                        for (int j=0; j< (radius+1); j = j+3) {
                            uLCD.circle(missile_record.x, missile_record.y, j, 0xFFFF00);

                        }
                        for (int j=0; j<(radius+1); j=j+3) {
                            uLCD.circle(missile_record.x, missile_record.y, j, BLACK_COLOR);

                        }
                        missile_set_exploded(w);

                        player_set_exploded(d);
                        s= s+1;
                        if(s==3) {
                            gameWin = true;
                        }
                    }
                }
            }
        }
    }
}