#include "mbed.h"
#include "timeDisplay.h"
#include "uLCD_4DGL.h"
#include "setAlarm.h"
#include "ledColorSequence.h"
#include "mathProblem.h"
#include "speaker.h"
#include "alarmChoice.h"
#include <string>

DigitalIn hourSet(p5);
DigitalIn minSet(p6);
DigitalIn gameChoice(p7);
DigitalIn missionControlWin(p28);
DigitalOut missionControlReset(p29);
DigitalOut missionControlStart(p30);
Serial device(USBTX,USBRX);
Serial bluetooth(p13,p14);
timeDisplay timeLCD;
setAlarm alarmSet;
ledColorSequence LedGame;
mathProblem mathProblemGame;
alarmChoice alarmGameChoice;
speaker speakerPlay;
Timer tSpeaker;
Timer tLED;

string currentTime;
string currentAlarmTime;
string chosenGameName = "LED Color Sequence";
char mathProblemAnswerStr [5];
string ledColorSeq = " ";
char input;
int chosenGame = 0;
int mathProblemAnswer=0;
int mathProblemAnswerLength;
int charCount = 0;
int matched = 0;
int score;

int main()
{
    hourSet.mode(PullDown);
    minSet.mode(PullDown);
    gameChoice.mode(PullDown);
    timeLCD.setTime();
    bluetooth.baud(115200);
    tSpeaker.start();
    tLED.start();
    while(1) {
        printf("%s", missionControlWin ? "true" : "false");
        currentTime = timeLCD.displayTime();
        currentAlarmTime = alarmSet.displayAlarmTime();
        alarmGameChoice.displayChoice();
        if(hourSet==1) {
            alarmSet.setHour();
        } else if (minSet==1) {
            alarmSet.setMinute();
        }
        if (gameChoice == 1) {
            chosenGameName = alarmGameChoice.setGameName();
            chosenGame = alarmGameChoice.setGame();
        }
        if (currentAlarmTime.compare(currentTime)==0) {
            speakerPlay.playSpeaker();
            if (chosenGame == 0) {
                ledColorSeq=LedGame.chooseColor();
                tLED.stop();
                tLED.reset();
                tLED.start();
                wait(.9);
            } else if (chosenGame == 1) {
                mathProblemAnswer = mathProblemGame.displayMathProblem();
                mathProblemAnswerLength = sprintf(mathProblemAnswerStr,"%d",mathProblemAnswer);
                wait(.9);
            } else if (chosenGame ==2) {
                missionControlReset=1;
                missionControlStart=1;
                wait(.9);
            }
        }
        if (ledColorSeq!=" ") {
            if(tSpeaker.read()>=7.65){
                tSpeaker.stop();
                tSpeaker.reset();
                tSpeaker.start();
                speakerPlay.playSpeaker();
            }
            if(tLED.read()>=5){
                tLED.stop();
                tLED.reset();
                tLED.start();
                LedGame.repeatColorSequence(ledColorSeq);
            }
            while(bluetooth.readable()) {
                while(charCount<ledColorSeq.length()) {
                    if (bluetooth.getc()==ledColorSeq[charCount]) {
                        matched++;
                        charCount++;
                    }
                }
                if (matched==ledColorSeq.length()) {
                    speakerPlay.turnOffSpeaker();
                    LedGame.turnOffColor();
                    ledColorSeq=" ";
                }
                charCount=0;
                matched=0;
            }
        } else if (mathProblemAnswer != 0) {
            if(tSpeaker.read()>=7.65){
                tSpeaker.stop();
                tSpeaker.reset();
                tSpeaker.start();
                speakerPlay.playSpeaker();
            }
            while(bluetooth.readable()) {
                while(charCount<mathProblemAnswerLength) {
                    if (bluetooth.getc()==mathProblemAnswerStr[charCount]) {
                        matched++;
                        charCount++;
                    }
                }
                if (matched==mathProblemAnswerLength) {
                    speakerPlay.turnOffSpeaker();
                    mathProblemGame.eraseMathProblem();
                    mathProblemAnswer=0;
                }
                charCount=0;
                matched=0;
            }
        } else if (missionControlStart == 1) {
            if(tSpeaker.read()>=7.65){
                tSpeaker.stop();
                tSpeaker.reset();
                tSpeaker.start();
                speakerPlay.playSpeaker();
            }
            if (missionControlWin == 1){
                missionControlReset=0;
                missionControlReset=1;
                missionControlStart=0;
                speakerPlay.turnOffSpeaker();
            }
        }
    }
}
