#include "mbed.h"
#include "timeDisplay.h"
#include "setAlarm.h"
#include "ledColorSequence.h"
#include <string>

Serial pc(USBTX,USBRX);
DigitalOut red(p22);
DigitalOut green(p23);
DigitalOut blue(p24);
int color;
int colorCount=0;
char colorSequence[5];

string ledColorSequence::chooseColor() 
{
    while(colorCount<4){
        color = rand()%3;
        if (color==0){
            red=1;
            colorSequence[colorCount] = 'r';
            wait(0.4);
            red=0;
        }else if (color==1){
            green=1;
            colorSequence[colorCount] = 'g';
            wait(0.4);
            green=0;
        }else if (color==2) {
            blue=1;
            colorSequence[colorCount] = 'b';
            wait(0.4);
            blue=0;
        }
        colorCount++;
    }
    colorSequence[4]='\0';
    colorCount=0;
    return colorSequence;
}

void ledColorSequence::repeatColorSequence(string colorSequence)
{
    while(colorCount<4){
        if (colorSequence[colorCount] == 'r'){
            red=1;
            wait(0.4);
            red=0;
        }else if (colorSequence[colorCount] == 'g'){
            green=1;
            wait(0.4);
            green=0;
        }else if (colorSequence[colorCount] == 'b') {
            blue=1;
            wait(0.4);
            blue=0;
        }
        colorCount++;
    }
    colorCount=0;
}

void ledColorSequence::turnOffColor()
{
    if (blue==1||green==1||red==1){
        blue=0;
        green=0;
        red=0;
    }
}

