// uLCD-144-G2 demo program for uLCD-4GL LCD driver library
//
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"

Ticker dirSet; 
Ticker XorY;
Serial pc (USBTX,USBRX);
Mutex mutex;

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
float fx1=rand()%100+1,fy1=rand()%100+1,fx2=rand()%100+1,fy2=rand()%100+1,fx3=rand()%100+1,fy3=rand()%100+1, vx=1, vy=1;
int x1=(int)fx1,y1=(int)fy1,x2=(int)fx2,y2=(int)fy2,x3=(int)fx3,y3=(int)fy3, radius=3;
int xory1;
int xory2;
int xdir1; 
int xdir2;
int ydir1;
int ydir2;
int hit1=0;
int hit2=0;
int timer=0;
int x4;
int y4;
char move;

void drawWalls() {
    //draw walls
    uLCD.line(0, 0, 127, 0, WHITE);
    uLCD.line(127, 0, 127, 127, WHITE);
    uLCD.line(127, 127, 0, 127, WHITE);
    uLCD.line(0, 127, 0, 0, WHITE);
}

void setxory(){
    xory1 = rand()%2;
    xory2 = rand()%2;
}
    
void setDir(){
    //set value of movement left/right and up/down
    xdir1 = rand()%2;
    ydir1 = rand()%2;
    xdir2 = rand()%2;
    ydir2 = rand()%2;
}

void drawBaddie1() {
    //draw baddie1
    uLCD.filled_circle(x1, y1, radius, RED);
}

void drawBaddie2() {  
    //draw baddie2  
    uLCD.filled_circle(x2, y2, radius, RED);
}
void eraseBaddie1() {
    //erase old baddie1's locations
    uLCD.filled_circle(x1, y1, radius, BLACK);
}
void eraseBaddie2() {
    //erase old baddie2's locations
    uLCD.filled_circle(x2, y2, radius, BLACK);
}
void moveBaddie1() {
    //move baddie1
    if (xory1==0){
        if ((xdir1==0)||(x1<=radius+1)) fx1=fx1+vx;
        if ((xdir1==1)||(x1>=126-radius)) fx1=fx1-vx;
    } else if (xory1==1){
        if ((ydir1==0)||(y1<=radius+1)) fy1=fy1+vy;
        if ((ydir1==1)||(y1>=126-radius)) fy1=fy1-vy;
    }
    x1=(int)fx1;
    y1=(int)fy1;
}

void moveBaddie2() {
    //move baddie2
    if (xory2==0){
        if ((xdir2==0)||(x2<=radius+1)) fx2=fx2+vx;
        if ((xdir2==1)||(x2>=126-radius)) fx2=fx2-vx;
    } else if (xory1==1){
        if ((ydir2==0)||(y2<=radius+1)) fy2=fy2+vy;
        if ((ydir2==1)||(y2>=126-radius)) fy2=fy2-vy;
    }
    x2=(int)fx2;
    y2=(int)fy2;
}

void drawHero() {
    //draw Hero
    uLCD.filled_circle(x3, y3, radius, GREEN);
}

void eraseHero() {
    //erase old hero's location
    uLCD.filled_circle(x3, y3, radius, BLACK);
}

void moveHero() {
    //move hero's location
    if (pc.readable()){
        move = pc.getc();
        if ((move=='d')||(x3<=radius+1)) fx3=fx3+2;
        else if ((move=='a')||(x3>=126-radius)) fx3=fx3-2;
        else if ((move=='s')||(y3<=radius+1)) fy3=fy3+2;
        else if ((move=='w')||(y3>=126-radius)) fy3=fy3-2;
    }
    x3=(int)fx3;
    y3=(int)fy3;
}
void bomb() {
    if (move=='m'){
        pc.printf("Boooooom!\n\r");    
        x4=x3;
        y4=y3;
        while(timer<=50){  
            uLCD.filled_circle(x4,y4,radius,BLUE);    
            drawHero();
            eraseHero();
            moveHero();
            drawHero();
            drawBaddie1();
            eraseBaddie1();        
            moveBaddie1();
            drawBaddie1();
            drawBaddie2();
            eraseBaddie2();        
            moveBaddie2();
            drawBaddie2();
            timer++;
        }
        timer=0;
        uLCD.filled_rectangle(x4+3, y4+20, x4-3, y4-20, BLUE);
        uLCD.filled_rectangle(x4+20, y4+3, x4-20, y4-3, BLUE);
        wait(1);
        uLCD.filled_rectangle(x4+3, y4+20, x4-3, y4-20, BLACK);
        uLCD.filled_rectangle(x4+20, y4+3, x4-20, y4-3, BLACK);
        if ((((x1-radius)<=(x4+20))&&((y1>=y4-5)&&(y1<=y4+5)))&&(((x1+radius)>=(x4-20))&&((y1>=y4-5)&&(y1<=y4+5)))){
            hit1=1;
            eraseBaddie1();
        }
        else if((((y1-radius)<=(y4+20))&&((x1>=x4-5)&&(x1<=x4+5)))&&(((y1-radius)>=(y4-20))&&((x1>=x4-5)&&(x1<=x4+5)))){
            hit1=1;
            eraseBaddie1();
        }
        else if ((((x2-radius)<=(x4+20))&&((y2>=y4-5)&&(y2<=y4+5)))&&(((x2+radius)>=(x4-20))&&((y2>=y4-5)&&(y2<=y4+5)))){
            hit2=1;
            eraseBaddie2();
        }
        else if ((((y2-radius)<=(y4+20))&&((x2>=x4-5)&&(x2<=x4+5)))&&(((y2-radius)>=(y4-20))&&((x2>=x4-5)&&(x2<=x4+5)))){
            hit2=1;
            eraseBaddie1();
        }
    }
}

int main(){
    uLCD.baudrate(300000);
    uLCD.background_color(BLACK);
    uLCD.cls();
    uLCD.text_width(1);
    uLCD.text_height(1);
    uLCD.printf("Modified Bomberman\n\r\n\rPress s\n\rto start Game");
    if(pc.getc()=='s'){
        uLCD.background_color(BLACK);
        uLCD.cls();
    }
    drawWalls();
    XorY.attach(&setxory, 0.5);
    dirSet.attach(&setDir,0.5);
    while(1){ 
        drawHero();
        eraseHero();
        moveHero();
        bomb();
        drawHero();  
        if(hit1!=1){    
            drawBaddie1();
            eraseBaddie1();        
            moveBaddie1();
            drawBaddie1();
        }
         if(hit2!=1){
            drawBaddie2();
            eraseBaddie2();        
            moveBaddie2();
            drawBaddie2();
        }
        if(hit1==1&&hit2==1)
        {
            uLCD.cls();
            uLCD.printf("YOU WIN!");
            break;
        }
    }
}