///////////////////////////////////////////////////////////////////////
// Thomas SAINT GUILHEM
// H00020042
// MSc Embedded Systems
//
// Width of first pulse (+50µs at ech following pulse)
// a    = s * 100µs   = 8  * 100µs   = 800µs
//
// Width of space between pulses
// b    = a * 100µs   = 1  * 100µs   = 100µs
//
// Number of pulses in a block
// c    = i * 7       = 9  + 7       = 16
//
// Space between pulse blocks
// d    = n * 500µs   = 13 * 500µs   = 6.5ms
//
// Mode = rem(t/4)+ 1 = rem(7/4) + 1 = 4
// My mode is mode 4 : half d and b time  until switch set back to 0
//
// Switch 1
// 0 = enable stream of pulses 
// 1 = disable stream of pulses 
//
// Switch 2
// 0 = run as normal mode (above waveform) 
// 1 = run with a modified waveform cycle 
//
// The waveform consists of a repeated set of cycles. The signal from Sig B can
// be used to trigger an oscilloscope display and should be 10µS. 
//
// Version
//   V1.0    February 2011
////////////////////////////////////////////////////////////////////////

#include "mbed.h"

DigitalOut SignalA(p5);     // Digital output for signal A
DigitalOut SignalB(p6);     // Digital output for signal B
DigitalIn Switch1(p7);      // Digital input for switch 1 (enable)
DigitalIn Switch2(p8);      // Digital input for switch 2 (mode)

int main()
{

int i;
int timeA = 800;         //Variable to store new length value for pulse
int time100us = 100;     //100µs
int time10us = 10;       //10µs
int time50us = 50;       //50µs
int time6500us = 6500;   //6.5ms
int time3250us = 3250;   //3.25ms
int NbLoop = 16;

    while (1)   // Infinite loop
    {
        // If Switch 1 is 0 then enable stream of pulse
        if (!Switch1)
        {
            // If switch 2 is 0 then run as normal mode
            if (!Switch2)
            {
                // Generate pulse of 10µs on Signal B
                SignalB = 1;
                wait_us(time10us);
                SignalB = 0;
                
                // Loop to generate 16 pulses spaced by 100µs
                // Each time it is looped, 50µs are added to the length of the pulse    
                for(i=0; i<NbLoop; i++)
                {
                    // Generate the pulse of length timeA
                    SignalA = 1;
                    wait_us(timeA);
                    SignalA = 0;
                    
                    // Delay of 100µs
                    wait_us(time100us);
                    // Increment of 50µs the previoous value
                    timeA +=  time50us;
                }
                // Before the next waveform cycle, wait for 6.5ms
                wait_us(time6500us);
            }
            // Else if switch 2 is 1 then run as modified mode 
            else
            {
                // Generate pulse of 10µs on Signal B
                SignalB = 1;
                wait_us(time10us);
                SignalB = 0;
                    
                // Loop to generate 16 pulses spaced by 100µs
                // Each time it is looped, 50µs are added to the length of the pulse
                for(i=0; i<NbLoop; i++)
                {
                    // Generate the pulse of length timeA
                    SignalA = 1;
                    wait_us(timeA);
                    SignalA = 0;
                    
                    // Delay of 50µs (mode 4)
                    wait_us(time50us);
                    // Increment of 50µs the previoous value
                    timeA +=  time50us;
                }
                // Before the next waveform cycle, wait for 3.25ms (Mode 4)
                wait_us(time3250us);
            }
        }
    }
}
