#ifndef __LORA_TRANSPORT__
#define __LORA_TRANSPORT__

#include "sx1272-hal.h"

#define RF_FREQUENCY                                868300000 // Hz
#define TX_OUTPUT_POWER                             20        // 14 dBm
#define RX_TIMEOUT_VALUE                            5000000   // in us
#define TX_TIMEOUT_VALUE                            5000000   // in us
#define LORA_BANDWIDTH                              0         // [0: 125 kHz, 1: 250 kHz, 2: 500 kHz, 3: Reserved]
#define LORA_SPREADING_FACTOR                       9         // [SF7..SF12]
#define LORA_CODINGRATE                             1         // [1: 4/5, 2: 4/6, 3: 4/7,  4: 4/8]
#define LORA_PREAMBLE_LENGTH                        8         // Same for Tx and Rx
#define LORA_SYMBOL_TIMEOUT                         5         // Symbols
#define LORA_FIX_LENGTH_PAYLOAD_ON                  false
#define LORA_FHSS_ENABLED                           false
#define LORA_NB_SYMB_HOP                            4
#define LORA_IQ_INVERSION_ON                        false
#define LORA_CRC_ENABLED                            true

#define MAX_PAYLOAD_SIZE 251

namespace LoraTransport {

    struct Packet {
        uint16_t from_addr;
        uint16_t to_addr;
        uint8_t  packet_number;
        uint8_t  payload[MAX_PAYLOAD_SIZE];
        uint8_t  payload_size;
    };

    struct Ack {
        uint16_t from_addr;
        uint16_t to_addr;
        uint8_t  packet_number;
        uint8_t  success;
    };

    enum State {
        IDLE,                   //0
        // TX cycle
        CAD_RUNNING,            //1
        CAD_POSITIVE,           //2
        CAD_NEGATIVE,           //3
        TX_MSG,                 //4
        TX_MSG_TIMEOUT,         //5
        TX_MSG_DONE,            //6
        RX_ACK,                 //7
        RX_ACK_TIMEOUT,         //8
        RX_ACK_ERROR,           //9
        RX_ACK_DONE,            //10
        TX_ERROR,               //11
        TX_SUCCESS,             //12
        // RX cycle
        RX_MSG,                 //13
        RX_MSG_TIMEOUT,         //14
        RX_MSG_ERROR,           //15
        RX_MSG_DONE,            //16
        TX_ERROR_ACK,           //17
        TX_ERROR_ACK_TIMEOUT,   //18
        TX_ERROR_ACK_DONE,      //19
        TX_SUCCESS_ACK,         //20
        TX_SUCCESS_ACK_TIMEOUT, //21
        TX_SUCCESS_ACK_DONE,    //22
        RX_ERROR,               //23
        RX_SUCCESS              //24

    };

    void init();
    void send(uint16_t addr, uint8_t *ptr, uint8_t len, uint32_t timeout = 20000000 /*µs -> 20s*/);
    void recv(uint32_t timeout = 20000000 /*µs -> 20s*/);
    bool done();
    bool success();

    void setAddress(uint16_t addr);
    State getState();
    State getLastErrorState();
    Packet& getPacket();
    int16_t getRSSI();
    int8_t getSNR();

};

#endif // __LORA_TRANSPORT__
