//#include "mbed.h"

#include "stm32f7xx.h"
#include "stm32746g_discovery.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32f7xx_hal_dma2d.h"
#include "ARGB4444_150x150.h"

#define LCD_MEM_ADDR (LCD_FB_START_ADDRESS + (480 * 272) * 4)

DMA2D_HandleTypeDef hdma2d;

void DMA2D_Config(void);
uint32_t ramBuffer[(150 * 150 * 2) / 4];
uint32_t offset = ((272 - 150) / 2 * 480 + (480 - 150) / 2) * 4;
uint32_t offset2 = ((272 - 260) / 2 * 480 + (480 - 150) / 2) * 4;
uint32_t offset3 = ((272 - 260) / 2 * 480 + (480 - 270) / 2) * 4;

int main(void)
{
    int xpos_offset = 0;
    int xpos_offset2 = 0;
    int ypos_offset3 = 0;
    HAL_Init();

    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(0, LCD_FB_START_ADDRESS);
    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_BLUE);
    BSP_LCD_SetFont(&Font16);

    DMA2D_Config();

    HAL_DMA2D_Start(&hdma2d, (uint32_t)&ARGB4444_150x150, (uint32_t)&ramBuffer, 150, 150);
    while(HAL_DMA2D_PollForTransfer(&hdma2d, 1000) != HAL_OK);

    hdma2d.Init.Mode = DMA2D_R2M ;
    hdma2d.Init.ColorMode = DMA2D_ARGB8888;
    hdma2d.Init.OutputOffset = 480 - 150;

    hdma2d.LayerCfg[1].AlphaMode = DMA2D_NO_MODIF_ALPHA;
    hdma2d.LayerCfg[1].InputAlpha = 0xff;
    hdma2d.LayerCfg[1].InputColorMode = CM_ARGB4444;
    hdma2d.LayerCfg[1].InputOffset = 0;

    HAL_DMA2D_Init(&hdma2d);
    HAL_DMA2D_ConfigLayer(&hdma2d, 1);
    HAL_DMA2D_Start(&hdma2d, (uint32_t)&ramBuffer, LCD_FB_START_ADDRESS + offset, 150, 150);
    HAL_DMA2D_Start(&hdma2d, 0xfff0f000, LCD_FB_START_ADDRESS + offset2, 50, 50);
    HAL_DMA2D_Start(&hdma2d, 0xffff0000, LCD_FB_START_ADDRESS + offset3, 50, 50);
    while(HAL_DMA2D_PollForTransfer(&hdma2d, 1000) != HAL_OK);
    int k=0;
    for(;;){
        // fill the previous position of image
        hdma2d.Init.Mode = DMA2D_R2M;
        HAL_DMA2D_Init(&hdma2d);
        //HAL_DMA2D_Start(&hdma2d, 0x00000000, LCD_FB_START_ADDRESS + offset + xpos_offset, 150, 150);
        HAL_DMA2D_Start(&hdma2d, 0x00000000, LCD_MEM_ADDR, 480, 272);
        while(HAL_DMA2D_PollForTransfer(&hdma2d, 1000) != HAL_OK);
        
        hdma2d.Init.Mode = DMA2D_R2M;
        hdma2d.Init.OutputOffset = 480 - 50;
        HAL_DMA2D_Init(&hdma2d);
        //HAL_DMA2D_Start(&hdma2d, 0x00000000, LCD_FB_START_ADDRESS + offset + xpos_offset, 150, 150);
        //HAL_DMA2D_Start(&hdma2d, 0xfff0f000, LCD_MEM_ADDR + (10 + 10 * 480) * 4, 50, 50);
        HAL_DMA2D_Start(&hdma2d, 0xfff0f000, LCD_MEM_ADDR + offset2 + xpos_offset2  , 50, 50);
        while(HAL_DMA2D_PollForTransfer(&hdma2d, 1000) != HAL_OK);
        
         hdma2d.Init.Mode = DMA2D_R2M;
        hdma2d.Init.OutputOffset = 480 - 50;
        HAL_DMA2D_Init(&hdma2d);
        //HAL_DMA2D_Start(&hdma2d, 0x00000000, LCD_FB_START_ADDRESS + offset + xpos_offset, 150, 150);
        HAL_DMA2D_Start(&hdma2d, 0xffff0000, LCD_MEM_ADDR + ((272 - ypos_offset3) / 2 * 480 + (480 - 270) / 2) * 4 , 50, 50);
        while(HAL_DMA2D_PollForTransfer(&hdma2d, 1000) != HAL_OK);
        
        // and move to the next
        if(xpos_offset<=300&&k==0){
            xpos_offset += 4;
            xpos_offset2 += 10;
            ypos_offset3 += 3;
            }
        if (xpos_offset == 300&&k==0)
            
            k=1;
        if(xpos_offset<=300&&k==1){
            xpos_offset -= 4;
            xpos_offset2 -= 10;
            ypos_offset3 -= 3;
            if(xpos_offset == 64)
            k=0;  
            }
       
         
        hdma2d.Init.Mode = DMA2D_M2M_PFC;
        hdma2d.Init.ColorMode = DMA2D_ARGB8888;
        hdma2d.Init.OutputOffset = 480 - 150;
        hdma2d.LayerCfg[1].AlphaMode = DMA2D_NO_MODIF_ALPHA;
        hdma2d.LayerCfg[1].InputAlpha = 0xff;
        hdma2d.LayerCfg[1].InputColorMode = CM_ARGB4444;
        hdma2d.LayerCfg[1].InputOffset = 0;
        HAL_DMA2D_Init(&hdma2d);
        HAL_DMA2D_ConfigLayer(&hdma2d, 1);
        //HAL_DMA2D_Start(&hdma2d, (uint32_t)&ramBuffer, LCD_FB_START_ADDRESS + offset + xpos_offset, 150, 150);
        HAL_DMA2D_Start(&hdma2d, (uint32_t)&ramBuffer, LCD_MEM_ADDR + offset + xpos_offset, 150, 150);
           
        while(HAL_DMA2D_PollForTransfer(&hdma2d, 1000) != HAL_OK);
        
         
        hdma2d.Init.OutputOffset = 0;
        hdma2d.LayerCfg[1].AlphaMode = DMA2D_NO_MODIF_ALPHA;
        hdma2d.LayerCfg[1].InputAlpha = 0xff;
        hdma2d.LayerCfg[1].InputColorMode = CM_ARGB8888;
        hdma2d.LayerCfg[1].InputOffset = 0;
        HAL_DMA2D_Init(&hdma2d);
        HAL_DMA2D_ConfigLayer(&hdma2d, 1);
        HAL_DMA2D_Start(&hdma2d, LCD_MEM_ADDR, LCD_FB_START_ADDRESS, 480, 272);
        while(HAL_DMA2D_PollForTransfer(&hdma2d, 1000) != HAL_OK);
        HAL_Delay(50);
    }
}

void DMA2D_Config(void) {
    hdma2d.Init.Mode = DMA2D_M2M;
    hdma2d.Init.OutputOffset = 0;
    hdma2d.Init.ColorMode = DMA2D_ARGB4444;

    hdma2d.Instance = DMA2D;

    hdma2d.LayerCfg[1].AlphaMode = DMA2D_NO_MODIF_ALPHA;
    hdma2d.LayerCfg[1].InputAlpha = 0xff;
    hdma2d.LayerCfg[1].InputOffset = 0;
    hdma2d.LayerCfg[1].InputColorMode = CM_ARGB4444;

    HAL_DMA2D_Init(&hdma2d);
    HAL_DMA2D_ConfigLayer(&hdma2d, 1);
}
