#ifndef _D7A_MODEM_H_
#define _D7A_MODEM_H_


//======================================================================
// MODEM commands over COM port
//======================================================================
typedef enum
{    //============================================
    // COMMANDS
    //============================================
    // Soft-reset Modem Device
    // ARGS: none
    WM_CMD_RST                      = 0x01,

    // Start D7A communication stack
    // ARGS: none TODO: pass number of fifos ?
    WM_CMD_D7A_STACK_START          = 0x02,

    // Stop D7A communication stack
    // ARGS: none
    WM_CMD_D7A_STACK_STOP           = 0x03,

    // Register a File for notification
    // ARGS: register_file_param_t
    WM_CMD_REGISTER_FILE            = 0x04,

    // Notify a (previously registered) file
    // ARGS: notify_file_param_t
    WM_CMD_NOTIFY_FILE              = 0x05,

    // Command that will be instantly answered with WM_OK
    // ARGS: none
    WM_CMD_READY                    = 0x06,

    //============================================
    // RESPONSES
    //============================================
    // Send by the Modem Device after a command has been executed/taken
    // into account, and the Modem is ready to handle a new command.
    // ARGS: none
    WM_OK                           = 0x80,

    // Send by the Modem Device after a (re)boot.
    // ARGS: boot_status_t
    WM_BOOT                         = 0x81,

    // Send by the Modem Device in case of failing command
    // ARGS: wm_error_code_t (u8)
    WM_ERROR                        = 0x82,

    // Send by the Modem Device upon the end of a File notification.
    // This response is generated depending on ALP's Retry-Policy ('respond' field set)
    // ARGS: wm_notif_result_t
    WM_NOTIF_DONE                   = 0x83,
} wm_cmd_t;

typedef enum {
    WM_ERR_NONE             = 0,
    WM_ERR_NOT_READY        = 1,
    WM_ERR_COM_LINK         = 2,
    WM_ERR_ILLEGAL_FID      = 3,
    WM_ERR_ILLEGAL_FILE_DEF = 4,

    WM_ERR_UNKNOWN     = 0xff
} wm_error_code_t;

typedef union {
    uint32_t w;
    struct {
        uint32_t cause          : 8;
        uint32_t rfu            : 8;
        uint32_t nb_boot        :16;
    } bf;
} boot_status_t;

typedef struct {
    union {
        uint8_t      b[8];
        uint32_t     w[2];
    } uid;
    uint8_t calib;
} wm_status_t;


TYPEDEF_STRUCT_PACKED {
    uint8_t  fid;
    uint8_t  type;
    uint8_t  afid;
    uint8_t  ifid;
    uint8_t  prop;
    uint8_t  perm;
    uint32_t size;
    uint32_t alloc;
} register_file_param_t;

typedef union {
    uint32_t w;
    struct {
        uint32_t fid            : 8;
        uint32_t offset         : 12;
        uint32_t size           : 12;
    } bf;
} notify_file_param_t;


d7a_errors_t d7a_modem_open(PinName reset_pin, NotifDoneFunction nd);
d7a_errors_t d7a_modem_close(void);
d7a_errors_t d7a_modem_reset(void);
d7a_errors_t d7a_modem_wait_ready(uint32_t millisec = osWaitForever);
void d7a_modem_new_pkt(d7a_com_rx_msg_t* pkt);
d7a_com_rx_msg_t* d7a_modem_wait_pkt(uint32_t millisec = osWaitForever);
void d7a_modem_msg(uint8_t value, uint8_t* buf, uint8_t len);
d7a_errors_t d7a_modem_register(register_file_param_t* file_infos);
d7a_errors_t d7a_modem_notify(notify_file_param_t* notif);
d7a_errors_t d7a_modem_start(void);
d7a_errors_t d7a_modem_stop(void);


#endif