#ifndef _D7A_ALP_H_
#define _D7A_ALP_H_

#define D7A_ALP_RESP_TO     (60000)

#define ALP_CTRL_GROUP      0x80
#define ALP_CTRL_RESP       0x40
#define ALP_CTRL_OVERLOAD   0x80
#define ALP_CTRL_INDIRECT   0x40
#define ALP_CTRL_EOP        0x80
#define ALP_CTRL_ERR        0x40

#define D7A_AUTH_PROTOCOLE_TOKEN_SIZE   (8)

typedef enum {
//      OPCODE                      | OPERAND
    ALP_OPCODE_NOP          = 0,  //|   -

    ALP_OPCODE_F_RD_DATA    = 1,  //|  FDR
    ALP_OPCODE_F_RD_PROP    = 2,  //|  FID

    ALP_OPCODE_F_WR_DATA    = 4,  //|  FD
    ALP_OPCODE_F_WR_FLUSH   = 5,  //|  FD
    ALP_OPCODE_F_WR_PROP    = 6,  //|  FD

    ALP_OPCODE_QUERY        = 8,  //|   Q
    ALP_OPCODE_QBREAK       = 9,  //|   Q
    ALP_OPCODE_PERM_REQ     = 10, //|   P

    ALP_OPCODE_CRC_CHECK    = 11, //|  Q

    ALP_OPCODE_F_EXIST      = 16, //|  FID
    ALP_OPCODE_F_CREATE     = 17, //|  FD
    ALP_OPCODE_F_DELETE     = 18, //|  FID
    ALP_OPCODE_F_RESTORE    = 19, //|  FID
    ALP_OPCODE_F_FLUSH      = 20, //|  FID
    ALP_OPCODE_F_OPEN       = 21, //|  FID
    ALP_OPCODE_F_CLOSE      = 22, //|  FID
    ALP_OPCODE_F_COPY       = 23, //|  2xFID
    ALP_OPCODE_F_EXECUTE    = 31, //|  FID

    ALP_OPCODE_RSP_F_DATA   = 32, //|  FD
    ALP_OPCODE_RSP_F_PROP   = 33, //|  FH
    ALP_OPCODE_RSP_STATUS   = 34, //|  S
    ALP_OPCODE_RSP_ISTATUS  = ALP_OPCODE_RSP_STATUS + (1 << 6), //|   SI
    ALP_OPCODE_RSP_TAG      = 35, //|  PID
    ALP_OPCODE_RSP_EOPTAG   = ALP_OPCODE_RSP_TAG + (2 << 6), //|   PID
    ALP_OPCODE_RSP_ERRTAG   = ALP_OPCODE_RSP_TAG + (1 << 6), //|   PID

    ALP_OPCODE_CHUNK        = 48, //|  -
    ALP_OPCODE_LOGIC        = 49, //|  -
    ALP_OPCODE_FORWARD      = 50, //|  I
    ALP_OPCODE_IFORWARD     = 51, //|  IFID
    ALP_OPCODE_TAG          = 52, //|  PID

    ALP_OPCODE_EXT          = 63, //|  RFU

    // Modifiers
    ALP_OPCODE_RESP         = 0x40,
    ALP_OPCODE_GROUP        = 0x80,

    ALP_OPCODE_ERR          = 0x40,
    ALP_OPCODE_EOP          = 0x80,

    ALP_OPCODE_INDIRECT     = 0x40,
    ALP_OPCODE_OVERLOAD     = 0x80,

} alp_opcodes_t;


typedef enum {
    ALP_RESP_TYPE_UNKNOWN = 0,
    ALP_RESP_TYPE_F_DATA  = ALP_OPCODE_RSP_F_DATA,
    ALP_RESP_TYPE_F_PROP  = ALP_OPCODE_RSP_F_PROP,
    ALP_RESP_TYPE_ISTATUS = ALP_OPCODE_RSP_ISTATUS,
    ALP_RESP_TYPE_STATUS  = ALP_OPCODE_RSP_STATUS,
    ALP_RESP_TYPE_TAG     = ALP_OPCODE_RSP_TAG,
} alp_resp_type_t;



typedef struct {
    uint8_t              type;
    uint8_t*             data;   // data
    union
    {
        struct {
            uint32_t             length;
            uint32_t             offset;
            uint8_t              fid;
        } f_data;
        struct {
            uint32_t             length;
            uint32_t             offset;
            uint8_t              fid;
        } f_prop;
        struct {
            uint8_t              code;
            uint8_t              id; // Action ID
        } status;
        struct {
            uint32_t             length;
            uint8_t              type;
        } itf;
        struct {
            uint8_t              id;
            uint8_t              eop;
            uint8_t              err;
        } tag;
    } meta;
} alp_uns_resp_parsed_t;

TYPEDEF_STRUCT_PACKED 
{
    uint8_t aid;
    int8_t status;
} d7a_alp_rsp_status_t;

#define NO_TAG      (-1)
TYPEDEF_STRUCT_PACKED 
{
    int16_t tag;
    bool eop;
    d7a_msg_t* msg;
} d7a_alp_rsp_t;



// =======================================================================
// d7a_ch_header_t
// -----------------------------------------------------------------------
/// Bitfield structure of the channel identifier
// =======================================================================
typedef union
{
    // bit access fields
    struct {
        /// Coding scheme
        uint8_t cs   : 2;
        /// Channel Class
        uint8_t cl   : 2;
        /// Channel Band
        uint8_t band : 3;
        /// RFU
        uint8_t rfu  : 1;
    } bf;

    // byte access
    uint8_t byte;

} d7a_ch_header_t;

// =======================================================================
// d7a_sp_status_t
// -----------------------------------------------------------------------
/// Bitfield structure of the D7ASP segment status byte
// =======================================================================
typedef union
{
    // bit access fields
    struct {
        /// RFU
        uint8_t rfu          : 4;
        /// Identifier type of the received segment
        uint8_t idf          : 2; 
        /// Current seqnum was already received
        uint8_t retry        : 1;
        /// There are not received seqnums anterior to the current seqnum
        uint8_t missed       : 1;
    } bf;

    // byte access
    uint8_t byte;

} d7a_sp_status_t;

// =======================================================================
// d7a_nwl_security_t
// -----------------------------------------------------------------------
/// NWL Security File structure
// =======================================================================
TYPEDEF_STRUCT_PACKED
{
    /// Key counter
    uint8_t key_counter;
    /// Frame counter
    uint32_t frame_counter;

} d7a_nwl_security_t;


// =======================================================================
// d7a_sp_res_t
// -----------------------------------------------------------------------
/// D7A specific segment metadata
// =======================================================================
TYPEDEF_STRUCT_PACKED
{
    /// channel header
    d7a_ch_header_t header;    
    /// channel index
    uint16_t idx;
    /// RSSI in -dBm
    int8_t  rxlev;
    /// Link budget in dB
    int8_t  lb;
    /// Target RXLEV in -dBm
    int8_t  target_rxlev;
    /// D7ASP status
    d7a_sp_status_t status;
    /// D7ASP Token
    uint8_t  token;
    /// D7ASP Sequence number
    uint8_t  seq;
    /// Response timeout
    uint32_t resp_to;
    /// Addressee
    d7a_addressee_t addressee;
    /// NLS security state (optional)
    d7a_nwl_security_t nls_state;

} d7a_sp_res_t;



d7a_errors_t d7a_alp_open(UnsolicitedMsgFunction uns_msg);
d7a_errors_t d7a_alp_close(void);
void d7a_alp_new_pkt(d7a_com_rx_msg_t* pkt);
d7a_com_rx_msg_t* d7a_alp_wait_pkt(uint32_t millisec = osWaitForever);
void d7a_alp_free_msg(d7a_msg_t* msg);
d7a_msg_t** d7a_alp_write_file(const uint8_t file_id, const uint32_t offset, const uint32_t size, const uint8_t* const buf, const uint8_t* root_key, d7a_addressee_t* addressee = NULL, uint8_t retry = 0, bool resp = true);
d7a_msg_t** d7a_alp_read_file(const uint8_t file_id, const uint32_t offset, const uint32_t size, const uint8_t* root_key, d7a_addressee_t* addressee = NULL, uint8_t retry = 0);
d7a_msg_t** d7a_alp_flush_file(const uint8_t file_id, const uint8_t* root_key, d7a_addressee_t* addressee, uint8_t retry, bool resp);
void d7a_alp_set_root_key_size(uint8_t size);


#endif // _D7A_ALP_H_
