#ifndef _D7A_COMMON_H_
#define _D7A_COMMON_H_

#define TYPEDEF_STRUCT_PACKED   typedef struct __attribute__((packed))

/*
typedef uint8_t  u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef int8_t   s8;
typedef int16_t  s16;
typedef int32_t  s32;
*/

#define HAL_U16_B0(a)           ((uint8_t)(((uint16_t)(a) >>  0) & 0xFF))
#define HAL_U16_B1(a)           ((uint8_t)(((uint16_t)(a) >>  8) & 0xFF))
#define HAL_U16_LO(a)           ((uint8_t)((a) >> 0))
#define HAL_U16_HI(a)           ((uint8_t)((a) >> 8))
#define HAL_TO_U16(a,b)         ((uint16_t)((uint16_t)(a) << 8)|(uint16_t)(b))
#define HAL_TO_U32(a,b,c,d)     ((uint32_t)((uint32_t)(a) <<24)|((uint32_t)(b) <<16)|((uint32_t)(c) << 8)|(uint32_t)(d))
#define HAL_U32_LO(a)           ((uint16_t)((a) >> 0))
#define HAL_U32_HI(a)           ((uint16_t)((a) >> 16))
#define HAL_U32_B0(a)           ((uint8_t)(((uint32_t)(a) >>  0) & 0xFF))
#define HAL_U32_B1(a)           ((uint8_t)(((uint32_t)(a) >>  8) & 0xFF))
#define HAL_U32_B2(a)           ((uint8_t)(((uint32_t)(a) >> 16) & 0xFF))
#define HAL_U32_B3(a)           ((uint8_t)(((uint32_t)(a) >> 24) & 0xFF))
// This should generate a REV instruction
#define HAL_U32_BYTE_SWAP(a)    (   (((a) & 0x000000ff) << 24) |   \
                                    (((a) & 0x0000ff00) <<  8) |   \
                                    (((a) & 0x00ff0000) >>  8) |   \
                                    (((a) & 0xff000000) >> 24))


#endif