#ifndef _D7A_SYS_H_
#define _D7A_SYS_H_

//======================================================================
// Dynamic Trace Module-IDs
//----------------------------------------------------------------------
typedef enum{
    TMOD_HAL =0,
    TMOD_KAL,
    TMOD_RAC,
    TMOD_MAC,
    TMOD_TRAN,
    TMOD_PRES,
    TMOD_ALP,
    TMOD_TST,
    TMOD_DRV,
    TMOD_APP,
    TMOD_CUP,
    TMOD_XCV,
    TMOD_D7A,
    TMOD_SVC,

    KAL_DBG_TLEV_MOD_QTY
}d7a_dbg_tlev_mod_t;

#define _HAL_EVENT_BASE     (1 << 10)
#define _BUTTON_EVENT       (0 << 5)

enum
{
    // Button events
    HAL_EVT_BUTTON1 = _HAL_EVENT_BASE+_BUTTON_EVENT,
    HAL_EVT_BUTTON2,
    HAL_EVT_BUTTON3,
    HAL_EVT_BUTTON4,
    HAL_EVT_BUTTON5,
    HAL_EVT_BUTTON6,
    HAL_EVT_BUTTON7,
    HAL_EVT_BUTTON8,
    HAL_EVT_BUTTON9,
};


d7a_errors_t d7a_sys_open(void);
d7a_errors_t d7a_sys_close(void);
void d7a_sys_new_pkt(d7a_com_rx_msg_t* pkt);
d7a_com_rx_msg_t* d7a_sys_wait_pkt(uint32_t millisec = osWaitForever);
void d7a_sys_tlev(uint8_t mod, uint16_t lev);
bool d7a_sys_ping_modem(uint32_t millisec = osWaitForever);
void d7a_sys_software_reset(void);
void d7a_sys_button(uint8_t button);
void d7a_sys_xack(void);




#endif