#include "mbed.h"
//  Small library for controll the TTL74HC595, who is a SerialIn-ParallelOut
//  Created by Michele Trombetta
//  Copyright 2010 5OFT. All rights reserved.

class ttl_74HC595 {
public:
    ttl_74HC595(PinName DS, PinName SH_CLK, PinName ST_CLK, PinName OE);
    void send_data(unsigned char data); //Send 1 byte to the IC
    void store_data();  //Store the data into the internal latch
    void send(unsigned char data);  //Rapid routine to send and store the data
    void setOE(bool enable);    //Clear or set the OE pin
private:
    DigitalOut _DS;
    DigitalOut _ST_CLK;
    DigitalOut _SH_CLK;
    DigitalOut _OE;
};