#include "mbed.h"
#include "ttl_74HC595.h"
//  Small library for controll the TTL74HC595, who is a SerialIn-ParallelOut
//  Created by Michele Trombetta
//  Copyright 2010 5OFT. All rights reserved.

ttl_74HC595::ttl_74HC595(PinName DS, PinName SH_CLK, PinName ST_CLK, PinName OE): _DS(DS), _SH_CLK(SH_CLK), _ST_CLK(ST_CLK), _OE(OE) {

}

void ttl_74HC595::send_data(unsigned char data) {
    for (char i=0; i<8; i++) {
        _SH_CLK = 0;
        _DS = data & 0x01;
        data >>= 1;
        _SH_CLK = 1;
    }
}

void ttl_74HC595::store_data() {
    _ST_CLK = 1;
    _ST_CLK = 0;
}

void ttl_74HC595::send(unsigned char data) {
    send_data(data);
    store_data();
}

void ttl_74HC595::setOE(bool enable) {
    _OE = enable ? 0 : 1;
}