#include "mbed.h"
//  Simple library that can controll a matrix of 7 segment led displays
//  Created by Michele Trombetta
//  Copyright 2010 5OFT. All rights reserved.

#ifndef  led_ANODE
#define led_ANODE 0
#define led_CATHODE 1
#endif

#ifndef  VAR_num_7seg
#define VAR_num_7seg
//Chars: 0123456789AbCdEF
const unsigned char num_7seg[24] = {0x3F, 0x6, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x7, 0x7F, 0x6F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00};
#endif

#ifndef  LIB_Multi7Seg
#define LIB_Multi7Seg
#define format_DEC  1
#define format_HEX  0
class Multi7Seg {
public:
    Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, bool led_type);
    Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, PinName disp3, bool led_type);
    Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, PinName disp3, PinName disp4, bool led_type);
    Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, PinName disp3, PinName disp4, PinName disp5, bool led_type);
    void write(unsigned int number); // Write the number to the led displays
    void setformat(bool format); // Set the format (0-Dec 1-Hex)
    void setspeed(float speed); // Set the delay time for digits scanning
    void setenabled(unsigned char enabled); // Enable or disable a single led display (by setting the bit of the argument "enabled")
private:
    BusOut  _disps;
    BusOut _led_7seg;
    unsigned char   _ndisp, _enabled;
    bool    _format, _led_type;
    float   _speed;
    unsigned int   _num1, _num2, _num3, _num4, _num5;
    void led_write(unsigned char number);
};
#endif