#include "mbed.h"
#include "Multi7Seg.h"
//  Simple library that can controll a matrix of 7 segment led displays
//  Created by Michele Trombetta
//  Copyright 2010 5OFT. All rights reserved.

Multi7Seg::Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, bool led_type): _disps(disp1, disp2), _led_7seg(a, b, c, d, e, f, g) {
    _ndisp = 2;
    _speed = 0.001;
    _led_type = led_type;
    _enabled = 0xFF;
}

Multi7Seg::Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, PinName disp3, bool led_type): _disps(disp1, disp2, disp3), _led_7seg(a, b, c, d, e, f, g) {
    _ndisp = 3;
    _speed = 0.001;
    _led_type = led_type;
    _enabled = 0xFF;
}

Multi7Seg::Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, PinName disp3, PinName disp4, bool led_type): _disps(disp1, disp2, disp3, disp4), _led_7seg(a, b, c, d, e, f, g) {
    _ndisp = 4;
    _speed = 0.001;
    _led_type = led_type;
    _enabled = 0xFF;
}

Multi7Seg::Multi7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, PinName disp1, PinName disp2, PinName disp3, PinName disp4, PinName disp5, bool led_type): _disps(disp1, disp2, disp3, disp4, disp5), _led_7seg(a, b, c, d, e, f, g) {
    _ndisp = 5;
    _speed = 0.001;
    _led_type = led_type;
    _enabled = 0xFF;
}

void Multi7Seg::write(unsigned int number) {
    if (_format) {  //Dec
        _num1 = number / 10000;
        _num2 = (number % 10000)/1000;
        _num3 = (number % 1000)/100;
        _num4 = (number % 100)/10;
        _num5 = number % 10;
    } else {    //Hex
        _num2 = (number % 65536)/4096;
        _num3 = (number % 4096)/256;
        _num4 = (number % 256)/16;
        _num5 = number % 16;
    }

    switch (_ndisp) {
        case 5:
            _disps = _led_type ? 255 : 0;
            if (_enabled & 0x10) {
                led_write((unsigned char)_num1);
                _disps = _led_type ? 254 : 16;
            }
            wait(_speed);
        case 4:
            _disps = _led_type ? 255 : 0;
            if (_enabled & 0x08) {
                led_write((unsigned char)_num2);
                _disps = _led_type ? 253 : 8;
            }
            wait(_speed);
        case 3:
            _disps = _led_type ? 255 : 0;
            if (_enabled & 0x04) {
                led_write((unsigned char)_num3);
                _disps = _led_type ? 251 : 4;
            }
            wait(_speed);
        case 2:
            _disps = _led_type ? 255 : 0;
            if (_enabled & 0x02) {
                led_write((unsigned char)_num4);
                _disps = _led_type ? 247 : 2;
            }
            wait(_speed);

            _disps = _led_type ? 255 : 0;
            if (_enabled & 0x01) {
                led_write((unsigned char)_num5);
                _disps = _led_type ? 239 : 1;
            }
            wait(_speed);
    }
    _disps = _led_type ? 255 : 0;
}

void Multi7Seg::setformat(bool format) {
    _format = format;
}

void Multi7Seg::setspeed(float speed) {
    _speed = speed;
}

void Multi7Seg::setenabled(unsigned char enabled) {
    _enabled = enabled;
}

void Multi7Seg::led_write(unsigned char number) {
    if (number<24) {
        if (_led_type) _led_7seg = num_7seg[number]; //Common Cathode
        else _led_7seg = ~num_7seg[number];  //Common Anode
    }
}