#include "mbed.h"
//  Simple library that can controll a 7 segment led display
//  Created by Michele Trombetta
//  Copyright 2010 5OFT. All rights reserved.

#ifndef  led_ANODE
#define led_ANODE 0
#define led_CATHODE 1
#endif

#ifndef  VAR_num_7seg
#define VAR_num_7seg
//Chars: 0123456789AbCdEF
const unsigned char num_7seg[24] = {0x3F, 0x6, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x7, 0x7F, 0x6F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00};
#endif

#ifndef  LIB_Led7Seg
#define LIB_Led7Seg
class Led7Seg {
public:
    Led7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g);
    Led7Seg(PinName a, PinName b, PinName c, PinName d, PinName e, PinName f, PinName g, bool led_type);
    void set_type(bool led_type);   // Set the tyep of the display (Anode or Cathode comm.)
    void write(unsigned char number);   // Write the data to the display
    unsigned char read();   // Read the data of the display
    unsigned char convert(unsigned char number);    // Only convert the data, no visualization
private:
    BusOut _leddisp;
    bool    _led_type;
};
#endif