#include "mbed.h"
#include "Led7Seg.h"
//  Simple library that can controll a 7 segment led display
//  Created by Michele Trombetta
//  Copyright 2010 5OFT. All rights reserved.

Led7Seg::Led7Seg(PinName a,PinName b,PinName c,PinName d,PinName e,PinName f,PinName g): _leddisp(a, b, c, d, e, f, g) {
    _leddisp = 0;
}

Led7Seg::Led7Seg(PinName a,PinName b,PinName c,PinName d,PinName e,PinName f,PinName g, bool led_type): _leddisp(a, b, c, d, e, f, g) {
    _leddisp = 0;
    _led_type = led_type;
}

void Led7Seg::set_type(bool led_type) {
    _led_type = led_type;
}

void Led7Seg::write(unsigned char number) {
    if (number<24) {
        if (_led_type) _leddisp = num_7seg[number]; //Common Cathode
        else _leddisp = ~num_7seg[number];  //Common Anode
    }
}

unsigned char Led7Seg::read() {
    return _leddisp;
}

unsigned char Led7Seg::convert(unsigned char number) {
    if (number<24) {
        if (_led_type) return num_7seg[number]; //Common Cathode
        else return ~num_7seg[number];  //Common Anode
    } else return 0xFF;
}