#include "mbed.h"
#include "Multi7Seg.h"
//##### A simple Clock #####
//  Created by Michele Trombetta
//  Copyright 2010 5OFT. All rights reserved.

Ticker  ticker_sec;
Multi7Seg   d_seconds(p21, p22, p23, p24, p25, p26, p27, p20, p19, led_ANODE);
Multi7Seg   d_minutes(p21, p22, p23, p24, p25, p26, p27, p18, p17, led_ANODE);
DigitalOut  seconds(p16);

unsigned int cnt_h = 0, cnt_m = 0, cnt_s = 0;

void inc_num() {
    cnt_s++;
    seconds = !seconds;
    if (cnt_s == 60) {
        cnt_s = 0;
        cnt_m++;
    }
    if (cnt_m == 60) {
        cnt_m = 0;
        cnt_h++;
    }
    if (cnt_h == 24) cnt_h = 0;
}

int main() {

    ticker_sec.attach(&inc_num, 1);
    seconds = 0;
    d_minutes.setformat(format_DEC);
    d_seconds.setformat(format_DEC);
    //d_seconds.setenabled(1); // Simple test to disable a single display
    while (1) {
        d_minutes.write(cnt_m);
        d_seconds.write(cnt_s);
    }
}