#include <string.h>
#include "mbed.h"
#include "easy-connect.h"
#include "TCPSocket.h"
#include "DHT.h"

DHT sensor(A0,DHT22);

#define SERVER_IP "192.168.0.7"
#define SERVER_PORT 50000

Serial pc(USBTX, USBRX); // computer to mbed boardSerial esp(D1, D0);

//void http_demo(NetworkInterface *net) { TCPSocket socket;       // for HTTP
//pc.printf("Sending HTTP request to %s : %d ...\r\n", SERVER_IP, SERVER_PORT);


char rbuffer[20];




int main(){
    int error = 0;
    pc.baud(115200);
    pc.printf("\r\n Simple HTTP example over ESP8266\r\n\r\n");

    pc.printf("\r\nConnecting...\r\n");
    
    NetworkInterface *network = easy_connect(true);
    while(!network){
        pc.printf("Error: Cannot connect to the network\r\n");
        wait(1);
        network = easy_connect(true);
    }
    
    pc.printf("Success\r\n\r\n");
    pc.printf("MAC: %s\r\n", network->get_mac_address());
    pc.printf("IP: %s\r\n", network->get_ip_address());
    pc.printf("Netmask: %s\r\n", network->get_netmask());
    pc.printf("Gateway: %s\r\n", network->get_gateway());
    pc.printf("RSSI: %d\r\n\r\n", wifi.get_rssi());

//    http_demo(network);
//    network->disconnect();
    pc.printf("\r\nDone\r\n");


    TCPSocket socket;

    socket.open(network);
    socket.connect(SERVER_IP, SERVER_PORT);

    int temp = 0, hum = 0;
    int scount, rcount;
    
    while(1){
        
        pc.printf("a710 server is %s : %d ...\r\n", SERVER_IP, SERVER_PORT);
        
        char rbuffer[64]={};
        
        rcount = socket.recv(rbuffer, sizeof rbuffer);
        
        pc.printf("%s\r\n", rbuffer);
        if(!strcmp(rbuffer, "GET /DHT22\r\n")){
            char sbuffer[64]={};
            scount = socket.send("OK\r\n", sizeof("OK\r\n"));
            error = sensor.readData();
            if (error == 0) {
                temp   = sensor.ReadTemperature(CELCIUS);
                hum   = sensor.ReadHumidity();
            }
            else {
                printf("Error: %d\r\n", error);
            }
            sprintf(sbuffer, "{ \"temp\": \"%d\", \"humid\": \"%d\"}\r\n", temp, hum);
            scount = socket.send(sbuffer, sizeof(sbuffer));
            pc.printf(sbuffer);
        }
        else{
            pc.printf("Unknown request\r\n");
            scount = socket.send("Unknown request\r\n", sizeof("Unknown request\r\n"));
        }
    }
}
