#include "mbed.h"
#include "Servo.h"
#include "rtos.h"
#include <string>

Servo r_arm(p24);
Servo l_arm(p23);
Servo r_leg(p22);
Servo l_leg(p21);

Thread t_r_arm;
Thread t_l_arm;
Thread t_r_leg;
Thread t_l_leg;

#define DUR 200

vector<string> move_map; //initialized in main
string note; 

void la_dance() {
    switch(note[0]){
        case 0: l_arm.write(1.0); break; 
        case 1: l_arm.write(0.0); break; 
    }
    Thread::wait(DUR);
}

void ra_dance() {
    switch(note[1]){
        case '0': r_arm.write(1.0); break; 
        case '1': r_arm.write(0.0); break; 
    }
    Thread::wait(DUR);
}

void ll_dance() {
    switch(note[2]){
        case 1: r_leg.write(1.0); break; 
        case 2: r_leg.write(0.6); break; 
        case 3: r_leg.write(0.1); break; 
    }
    Thread::wait(DUR);
}

void rl_dance() {
    switch(note[3]){
        case 1: l_leg.write(1.0); break; 
        case 2: l_leg.write(0.6); break; 
        case 3: l_leg.write(0.1); break; 
    }
    Thread::wait(DUR);
}

void puppet_move(){
    t_r_arm.start(ra_dance);
    t_l_arm.start(la_dance);
    t_r_leg.start(rl_dance);
    t_l_leg.start(ll_dance);
}

