#include "mbed.h"
#include <iostream>
#include <vector>
#include "speaker_out.h"
#include "motor_ctl.h"
#include "SongPlayer.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

//  State Machine control global variables
bool X;     //reset
bool P;     //play
bool S;     //stop
bool R;     //record
bool E;     //erase

enum sm_state {sRESET, sSTOP, sRECORD, sPLAY, sERASE};
int curr_state = 1; 

Serial pc(USBTX,USBRX);
Speaker mySpeaker(p26);
float time_limit = 30;
//Timer t; 

//SongPlayer music; 
//Puppet puppet;
vector<float> song; //stores all notes recorded by user
vector<string> dance; 


void reset(){ 
    /* reset state:
        Initial state upon powering up the device
        1. Cease all motion
        2. Reset all motors to initial position
        3. Mutes all audio
        4. Goes to erase state if reset button is held down for at least 3 seconds
        5. Goes to stop state according to rotary switch input
        6. LED goes from green to red
        NOTE: ONLY exits to stop or erase state 
    */
    //puppet.reset();
    //music.reset();
    //led = red; //use rgb red for this
}
void stop(){
    /* stop state:
        Initiated by rotary switch
        1. Cease all motion
        2. Stop recording
        3. Mute all audio
    */
    //puppet.stop();
    //music.stop(); 
}
void record(){
    /* record state:
        Initiated by rotary switch
        1. Cease all motion
        2. Begin recording ToF inputs (distance and time)
        3. Convert distances to corresponding audio frequencies
        4. Append to list of frequencies
        5. 
    */
    float freq; 
    char note; 
    t.start();
    while(t.read() < 30){
        note = pc.getc();
        switch (note){
            case 'a':
                freq = 523.25;
                dance.push_back(move_map[0]);
                break;
            
            case 's':
                freq = 554.37;
                dance.push_back(move_map[1]);
                break;
            
            case 'd':
                freq = 587.33;
                dance.push_back(move_map[2]);
                break;
            
            case 'f':
                freq = 622.25;
                dance.push_back(move_map[3]);
                break;
            
            case 'g':
                freq = 659.26;
                dance.push_back(move_map[4]);
                break;
            
            case 'h':
                freq = 698.46;
                dance.push_back(move_map[5]);
                break;
            
            case 'j':
                freq = 739.99;
                dance.push_back(move_map[6]);
                break;
            
            case 'k':
                freq = 783.99;
                dance.push_back(move_map[7]);
                break;
            
            case 'l':
                freq = 830.61;
                dance.push_back(move_map[8]);
                break;
            
            case 'q':
                freq = 880.00;
                dance.push_back(move_map[9]);
                break;
            
            case 'w':
                freq = 932.33;
                dance.push_back(move_map[10]);
                break;
            
            case 'e':
                freq = 987.77;
                dance.push_back(move_map[11]);
                break;
            }
            song.push_back(freq);
            mySpeaker.PlayNote(freq,0.2,0.5);
            
        }
        t.stop();
        //curr_state = 3; 

}
void play(){
    /* play state:
        Initiated by rotary switch
        1. wait a few seconds
        2. begin reading list of frequencies while concurrently:
            - moving servo motors accordingly
            - playing corresponding sounds
    */
    SongPlayer mySpeaker(p26, song);
    mySpeaker.PlaySong(DUR);
}
void erase(){
    /* erase state:
        erases entire audio recording
    */
    //song.erase();
}

void state_machine_mgr(){
    
    char key_input;
    X = 1;
    S = 0;
    R = 0;
    P = 0;
    E = 0;
    while(1) {
        if (pc.readable()) {                // if they have pressed a key
            key_input = pc.getc();
            if(key_input == '1') X=1;   //toggle reset
            if(key_input == '2') S=1;   //toggle stop
            if(key_input == '3') R=1;   //toogle record
            if(key_input == '4') P=1;   //toggle play
            if(key_input == '5') E=1;   //toggle erase
        }
        //pc.printf("X: %d\n",X);
//        pc.printf("S: %d\n",S);
//        pc.printf("R: %d\n",R);
//        pc.printf("P: %d\n",P);
//        pc.printf("E: %d\n",E);
//        pc.printf("Current State %d\n",curr_state);
        switch(curr_state){
            case 1:
                pc.printf("RESET\n");
                P = 0;
                R = 0;
                if(E){
                    curr_state = 5;
                    X = 0;
                }else if(S){
                    curr_state = 2;
                    X = 0;
                }
                reset();
                break;
            case 2:
                pc.printf("STOP\n");
                E = 0;
                if(X){
                    curr_state = 1;
                    S = 0;
                }else if(R){
                    curr_state = 3;
                    S = 0;
                }else if(P){
                    curr_state = 4;
                    S = 0;
                }
                stop();
                break;
            case 3:
                pc.printf("RECORD\n");
                E = 0;
                P = 0;
                if(X){
                    curr_state = 1;
                    R = 0;
                }else if(S){
                    curr_state = 2;
                    R = 0;
                }
                record();
                break;
            case 4:
                pc.printf("PLAY\n");
                E = 0;
                R = 0;
                if(X){
                    curr_state = 1;
                    P = 0;
                }else if(S){
                    curr_state = 2;
                    P = 0;
                }
                play();
                break;
            case 5:
                pc.printf("ERASE\n");
                S = 0;
                P = 0;
                R = 0;
                if(X){
                    curr_state = 1;
                    E = 0;
                }
                erase();
                break;
        }
    }
}

int main() {
    //initialize map of freq to movements
    move_map.push_back("1111");
    move_map.push_back("1011");
    move_map.push_back("0111");
    move_map.push_back("1122");
    move_map.push_back("1022");
    move_map.push_back("0122");
    move_map.push_back("1133");
    move_map.push_back("1033");
    move_map.push_back("0133");
    move_map.push_back("0031");
    move_map.push_back("0013");
    move_map.push_back("1101");
    state_machine_mgr();
    //puppet_move();
    //record();
}
