#include "mbed.h"
#include <vector>

class SongPlayer
{
public:
    SongPlayer(PinName pin, vector<float> freq) : _pin(pin), frequency(freq) {
    }
    void PlaySong(float duration, float volume=1.0) {
        vol = volume;
        notecount = 0;
        _pin.period(1.0/frequency[notecount]);
        _pin = volume/2.0;
        noteduration.attach(this,&SongPlayer::nextnote, DUR);
    }
    void nextnote();
    
private:
    Timeout noteduration;
    PwmOut _pin;
    int notecount;
    float vol;
    vector<float> frequency;
};

void SongPlayer::nextnote()
{
    _pin = 0.0;
    notecount++; //setup next note in song
    if (frequency[notecount]==0.0) notecount = 0; 
    _pin.period(1.0/frequency[notecount]);
    noteduration.attach(this,&SongPlayer::nextnote, DUR);
    _pin = vol/2.0;
}