#include "Buzzy.h"
#include "Ghosts.h"
#include "BuzzyGraphics.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"

extern char gDynaMaze[MAZE_NUM_ROW][MAZE_NUM_COL]; 
extern Ghosts gGhosts[NUM_GHOSTS];
extern Buzzy gBuzzy;
extern uLCD_4DGL guLCD;
extern Speaker gSpeakerOut;
extern DigitalOut myled1;



/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
// Constructor
Buzzy::Buzzy(enDIRECTIONS inDir, unsigned int inRow, unsigned int inCol):
Sprite(inDir, inRow, inCol)
{
  m_CurrentDirection = RIGHT_DIR;   
}    
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void Buzzy::Move()
{

    if (m_DesiredDirection == NO_DIR)
    { 
        // Nothing to do
        // Switch over to the siren sound
        gSpeakerOut.SwitchSound(Speaker::SIREN);
        return;
    }
    
    //Try to move Buzzy in desired direction
    switch(m_DesiredDirection){
            
        case UP_DIR: {
            if (IsMoveAllowed(m_RowPos+1, m_ColPos)) {
                    m_CurrentDirection = UP_DIR;
                } else {
                    //m_CurrentDirection = NO_DIR;
                }
                break;
            }
            
            case DOWN_DIR: {
                if (IsMoveAllowed(m_RowPos-1, m_ColPos)) {
                    m_CurrentDirection = DOWN_DIR;
                }else {
                    //m_CurrentDirection = NO_DIR;
                }
                break;
            }
            
            case LEFT_DIR: {
                if (IsMoveAllowed(m_RowPos, m_ColPos-1)) {
                    m_CurrentDirection = LEFT_DIR;
                }else {
                   // m_CurrentDirection = NO_DIR;
                }
                break;
            }
            
            case RIGHT_DIR: {
                if (IsMoveAllowed(m_RowPos, m_ColPos+1)) {
                    m_CurrentDirection = RIGHT_DIR;
                }else {
                    //m_CurrentDirection = NO_DIR;
                }
                break;
            }
        }
            
        //if you can't move in the desired direction keep going in the current direction 
        switch(m_CurrentDirection){
            case UP_DIR:{
                if (IsMoveAllowed(m_RowPos+1, m_ColPos)){
                    gBuzzy.DrawInNewLocation(m_RowPos+1, m_ColPos);
                }
                break;
            }
            case DOWN_DIR:{
                if (IsMoveAllowed(m_RowPos-1, m_ColPos)){
                gBuzzy.DrawInNewLocation(m_RowPos-1, m_ColPos);
                }
                break;
            }
            case LEFT_DIR:{
                if (IsMoveAllowed(m_RowPos, m_ColPos-1)){
                gBuzzy.DrawInNewLocation(m_RowPos, m_ColPos-1);
                }
                break;
            }
            case RIGHT_DIR:{
                if (IsMoveAllowed(m_RowPos, m_ColPos+1)){
                gBuzzy.DrawInNewLocation(m_RowPos, m_ColPos+1);
                }
                break;
            }
        }
            
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void Buzzy::DrawInNewLocation(const int &nRow,const int &nCol)
{
    int x1, y1;
    // Test if we hit a honeydrop or fruit or ghost
    if (gDynaMaze[nRow][nCol] == HONEYDROP_SQUARE){
        gBuzzy.honey++;
        gSpeakerOut.SwitchSound(Speaker::CHOMP);
        myled1 = !myled1;
    } else {
        gSpeakerOut.SwitchSound(Speaker::SIREN);
        myled1 = !myled1;
    }
    
    x1 = (3*m_RowPos+1)-4;
    y1 = (3*m_ColPos+1)-4;                     
    guLCD.BLIT(x1, y1, 9, 9, &BuzzyIcon[2][0][0]);


    //update the dynamic maze
    gDynaMaze[m_RowPos][m_ColPos] = 0;
    gDynaMaze[nRow][nCol] = 5;
    
    //draw Buzzy in new location
    x1 = (3*nRow+1)-4;
    y1 = (3*nCol+1)-4;                     
    guLCD.BLIT(x1, y1, 9, 9, &BuzzyIcon[GetImageIndex()][0][0]);   
    
    //update Buzzy's location 
    gBuzzy.SetLocation(nRow, nCol);  
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool Buzzy::DidGhostGetBuzzy()
{

    return false;
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
bool Buzzy::IsMoveAllowed(const int &nNewRow, const int &nNewCol)
{
    bool a,b,c;
    
    switch(m_DesiredDirection){
        case UP_DIR: {
            a = gCnstMaze[nNewRow+1][nNewCol-1] != 1;
            b = gCnstMaze[nNewRow+1][nNewCol] != 1;
            c = gCnstMaze[nNewRow+1][nNewCol+1] != 1; 
            break;
        }
        case DOWN_DIR: {
            a = gCnstMaze[nNewRow-1][nNewCol-1] != 1;
            b = gCnstMaze[nNewRow-1][nNewCol] != 1;
            c = gCnstMaze[nNewRow-1][nNewCol+1] != 1;
            break;
        }
        case LEFT_DIR: {
            a = gCnstMaze[nNewRow-1][nNewCol-1] != 1;
            b = gCnstMaze[nNewRow][nNewCol-1] != 1;
            c = gCnstMaze[nNewRow+1][nNewCol-1] != 1;
            break;
        }
        case RIGHT_DIR: {
            a = gCnstMaze[nNewRow-1][nNewCol+1] != 1;
            b = gCnstMaze[nNewRow][nNewCol+1] != 1;
            c = gCnstMaze[nNewRow+1][nNewCol+1] != 1;
            break;
        }
    }
  
    return a && b && c;    
    
}
