#include "uLCD_4DGL.h"
#include "BuzzyGraphics.h"
#include "Buzzy.h"

extern uLCD_4DGL guLCD;
extern char gDynaMaze[MAZE_NUM_ROW][MAZE_NUM_COL]; 
extern Buzzy gBuzzy;
/////////////////////////////////////////////////////////////////////
// The maze is a scaled down version of the LCD display
// Each element in the maze is really a 3x3 segment of the LCD
// This must be taken into account when drawing the maze on the LCD


// Draw a wall tile when 
void DrawMazeWall(int const &x1, int const &y1)
{
    int ii = 3*x1+1;
    int jj = 3*y1+1;
    guLCD.filled_rectangle(ii-1, jj-1, ii+1, jj+1, _BLUE);
}
/*
//////////////////////////////////////////////////////////////////////
Use the following #defines to determine which icon to draw in the LCD
#define BLUE_SQUARE 1
#define HONEYDROP_SQUARE 2
#define PWRUP_SQUARE 3
#define GHOST_ICON 4
#define BUZZY_ICON 5
#define TRAP_LINE 6

When drawing the ghosts draw one of each color
*/
void DrawMaze()
{
    
    for (int ii = 0 ; ii < MAZE_NUM_ROW ; ii++)
    {
        for (int jj = 0 ; jj < MAZE_NUM_COL ; jj++)
        {
            if (gDynaMaze[ii][jj] == HONEYDROP_SQUARE){
                guLCD.BLIT(ii*3, jj*3, 3, 3, &HoneyDropIcon[0][0]);
            } else if (gDynaMaze[ii][jj] == BLUE_SQUARE){
                DrawMazeWall(ii, jj);
            } else if (gDynaMaze[ii][jj] == PWRUP_SQUARE){
                guLCD.BLIT((ii*3+1)-4, (jj*3+1)-4, 9, 9, &PowerUpIcon[0][0]);
            } else if (gDynaMaze[ii][jj] == GHOST_ICON){
                guLCD.BLIT((ii*3)-4, (jj*3)-4, 9, 9, &VioletGhost[0][0][0]);
            } else if (gDynaMaze[ii][jj] == BUZZY_ICON){
                guLCD.BLIT((3*ii+1)-4, (3*jj+1)-4, 9, 9, &BuzzyIcon[0][0][0]);
                gBuzzy.SetLocation(ii,jj);
            }
        }
    }
}