// Project includes
#include "globals.h"
#include "hardware.h"
#include "map.h"
#include "graphics.h"
#include "speech.h"
#include "pausemenu.h"

int PauseMenu::switch_ax = 0;

PauseMenu::PauseMenu(Player* player) : 
    p(player), 
    quest_complete(player->quest_complete)
{

    //draw pink rectangle on whole screen
    uLCD.filled_rectangle(0, 128, 128, 70, PINK1);

    // write title
    uLCD.locate(1,11);
    uLCD.textbackground_color(YELLOW);
    uLCD.color(BLACK);
    uLCD.printf("Game Paused");

}

int PauseMenu::update(int action){
    switch(action)
    {
        case 1: 
            //if button 1 pressed move to next menu item
            button_presses = button_presses++;
            break;
        case 2:
            if (button_presses%4 == 0) {//Start game
                o_status();
            } else if (button_presses%4 == 1){ //Quit (screen cut to black)
                o_inventory();
            }else if (button_presses%4 == 2){ //Quit (screen cut to black)
                set_config(o_config());
            } else { //screen go white
                exit_en = true;
                terminate = true; 
            }
            break;
    }
    return 0;
    }

void PauseMenu::draw(int){
    if (button_presses%4 == 0){
        status_color = GREEN;
    } else if (button_presses%4 == 1){
        inventory_color = GREEN;
    }else if (button_presses%4 == 2){ 
        config_color = GREEN;
    }  else{
        exit_color = GREEN;
    }
    
    uLCD.locate(1,11);
    uLCD.textbackground_color(YELLOW);
    uLCD.color(BLACK);
    uLCD.printf("Game Paused");
    
    uLCD.locate(1,12);
    uLCD.color(status_color);
    uLCD.printf("View Status");
    
    uLCD.locate(1,13);
    uLCD.color(inventory_color);
    uLCD.printf("Inventory");
    
    uLCD.locate(1,14);
    uLCD.color(config_color);
    uLCD.printf("Config");
    
    uLCD.locate(1,15);
    uLCD.color(exit_color);
    uLCD.printf("Exit");
    
    
    status_color = BLACK;
    inventory_color = BLACK;
    config_color = BLACK;
    exit_color = BLACK;
    }

int PauseMenu::o_status(){
    uLCD.filled_rectangle(0, 128, 128, 80, PINK1);
    uLCD.locate(1,12);
    uLCD.textbackground_color(YELLOW);
    uLCD.color(BLACK);
    
    if (quest_complete){
        uLCD.printf("Congrats! You have completed your quest!");
    } else{
        uLCD.printf("Quest is not     completed");
    }
    
    uLCD.locate(10,15);
    uLCD.color(GREEN);
    uLCD.printf("Back");
    
    GameInputs inp = read_inputs();
    while(1){
        if(!inp.b3){
            uLCD.filled_rectangle(0, 128, 128, 80, PINK1); //erase option
            wait(1);
            return 0;
        }
        inp = read_inputs();
        wait(1);
    }
    }
int PauseMenu::o_inventory(){
    uLCD.filled_rectangle(0, 128, 128, 80, PINK1);
    uLCD.locate(1,12);
    uLCD.textbackground_color(YELLOW);
    uLCD.color(BLACK);
    
    char str[30];
    sprintf(str, "You have %d gems.", p->gems);
    uLCD.printf(str);
    
    uLCD.locate(10,15);
    uLCD.color(GREEN);
    uLCD.printf("Back");
    
    GameInputs inp = read_inputs();
    while(1){
        if(!inp.b3){
            uLCD.filled_rectangle(0, 128, 128, 80, PINK1); //erase option
            wait(1);
            return 0;
        }
        inp = read_inputs();
        wait(1);
    }
}
int PauseMenu::o_config(){
    uLCD.filled_rectangle(0, 128, 128, 80, PINK1);
    uLCD.locate(1,12);
    uLCD.textbackground_color(YELLOW);
    uLCD.color(BLACK);
    
    uLCD.printf("Press Button 2 to Switch Axis.");
    
    uLCD.locate(10,15);
    uLCD.color(GREEN);
    uLCD.printf("Back");
    
    int switch1;
    GameInputs inp = read_inputs();
    while(1){
        if(!inp.b2){
            uLCD.filled_rectangle(0, 128, 128, 80, PINK1);
            uLCD.locate(1,12);
            uLCD.printf("Axis switched.");
            uLCD.color(BLACK);
            uLCD.locate(10,15);
            uLCD.color(GREEN);
            uLCD.printf("Back");
            int switch1 = !switch_ax;
        }
        
        if(!inp.b3){
            uLCD.filled_rectangle(0, 128, 128, 80, PINK1); //erase option
            wait(1);
            return switch1;
        }
        inp = read_inputs();
        wait(1);
    }
    }