#include "map.h"

#include "globals.h"
#include "graphics.h"

/**
 * The Map structure. This holds a HashTable for all the MapItems, along with
 * values for the width and height of the Map.
 */


/**
 * Storage area for the maps.
 * This is a global variable, but can only be access from this file because it
 * is static.
 */
static Map maps[3];
static int active_map;

/**
 * The first step in HashTable access for the map is turning the two-dimensional
 * key information (x, y) into a one-dimensional unsigned integer.
 * This function should uniquely map (x,y) onto the space of unsigned integers.
 */
static unsigned XY_KEY(int X, int Y) {
    Map * m = get_active_map();
    return (m->w)*Y + X;
}

/**
 * This is the hash function actually passed into createHashTable. It takes an
 * unsigned key (the output of XY_KEY) and turns it into a hash value (some
 * small non-negative integer).
 */
unsigned map_hash(unsigned key)
{
    // TODO: Fix me!
    return key%5;
}

void maps_init(int h, int w, int buckets)
{
    Map * m = get_active_map();
    m->items = createHashTable(map_hash, buckets);
    m->w = w;
    m->h = h;
}

Map* get_active_map()
{
    
    return &(maps[active_map]);
}

Map* set_active_map(int m)
{
    active_map = m;
    return &(maps[active_map]);
}

void print_map()
{
    // As you add more types, you'll need to add more items to this array.
    char lookup[] = {'W', 'P'};
    for(int y = 0; y < map_height(); y++)
    {
        for (int x = 0; x < map_width(); x++)
        {
            MapItem* item = get_here(x,y);
            if (item) pc.printf("%c", lookup[item->type]);
            else pc.printf(" ");
        }
        pc.printf("\r\n");
    }
}

int map_width()
{
    Map * m = get_active_map();
    return m->w;
}

int map_height()
{
    Map * m = get_active_map();
    return m->h;
}

int map_area()
{
    Map * m = get_active_map();
    return (m->h)*(m->w);
}

MapItem* get_north(int x, int y)
{
    Map* map = get_active_map();
    //get key of item north of the location
    int index = XY_KEY(x, y-1);
    return (MapItem*)getItem(map->items, index);
}

MapItem* get_south(int x, int y)
{
    Map* map = get_active_map();
    int index = XY_KEY(x, y+1);
    return (MapItem*)getItem(map->items, index);
}

MapItem* get_east(int x, int y)
{
    Map* map = get_active_map();
    int index = XY_KEY(x-1, y); //wtf why does this work boi 
    return (MapItem*)getItem(map->items, index);
}

MapItem* get_west(int x, int y)
{
    Map* map = get_active_map();
    int index = XY_KEY(x+1, y); //shouldn't this be minus?
    return (MapItem*)getItem(map->items, index);
}

MapItem* get_here(int x, int y)
{
    Map* map = get_active_map();
    int index = XY_KEY(x, y);
    return (MapItem*)getItem(map->items, index);
}


void map_erase(int x, int y)
{
    Map* map = get_active_map();
    int index = XY_KEY(x, y);
    deleteItem(map->items, index);
}


void add_wall(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = WALL;
        w1->draw = draw_wall;
        w1->walkable = false;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}

/*void add_road(int x, int y, int dir, int len)
{
    for(int i = 0; i < len; i++)
    {
        MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
        w1->type = ROAD;
        w1->draw = draw_wall;
        w1->walkable = true;
        w1->data = NULL;
        unsigned key = (dir == HORIZONTAL) ? XY_KEY(x+i, y) : XY_KEY(x, y+i);
        void* val = insertItem(get_active_map()->items, key, w1);
        if (val) free(val); // If something is already there, free it
    }
}*/

void add_lbush(int x, int y, int key){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = LBUSH;
    w1->draw = draw_lbush;
    w1->walkable = true;
    MapItem* w2 = (MapItem*) malloc(sizeof(MapItem));
    w2->type = LBUSH;
    w2->draw = draw_lbush;
    w2->walkable = true;
    MapItem* w3 = (MapItem*) malloc(sizeof(MapItem));
    w3->type = LBUSH;
    w3->draw = draw_lbush;
    w3->walkable = true;
    MapItem* w4 = (MapItem*) malloc(sizeof(MapItem));
    w4->type = LBUSH;
    w4->draw = draw_lbush;
    w4->walkable = true;
    
    Lbush* b1 = (Lbush*)malloc(sizeof(Lbush));
    b1 -> key = key;
    
    w1 -> data = b1;
    w2 -> data = b1;
    w3 -> data = b1;
    w4 -> data = b1;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
    void* val1 = insertItem(get_active_map()->items, XY_KEY(x+1, y), w2);
    if (val1) free(val); // If something is already there, free it
    void* val2 = insertItem(get_active_map()->items, XY_KEY(x, y+1), w3);
    if (val2) free(val); // If something is already there, free it
    void* val3 = insertItem(get_active_map()->items, XY_KEY(x+1, y+1), w4);
    if (val3) free(val); // If something is already there, free it
}

void add_bush_rect(int a, int b, int c, int d){
    
    for(int i = a; i < c; i++){
        for(int j = b; j < d; j++){
            MapItem* b = (MapItem*) malloc(sizeof(MapItem));
            b->type = LBUSH;
            b->draw = draw_lbush;
            b->walkable = true;
    
            Lbush* bush = (Lbush*)malloc(sizeof(Lbush));
            bush -> key = XY_KEY(i,j);
            b -> data = bush;
            void* val = insertItem(get_active_map()->items, XY_KEY(i, j), b);
            if (val) free(val); // If something is already there, free it
        }
    }
}

void add_plant(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = PLANT;
    w1->draw = draw_plant;
    w1->walkable = true;
    w1->data = NULL;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_rock(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = ROCK;
    w1->draw = draw_rock;
    w1->walkable = false;
    Rock* r = (Rock*) malloc(sizeof(Rock));
    //r -> is_pushed = false;
    //r -> wall_touch = false;
    //r -> x = x;
    //r -> y = y;
    w1->data = r;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_npc(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = NPC;
    w1->draw = draw_npc;
    w1->walkable = false;
    NonPlayer* npc = (NonPlayer*) malloc(sizeof(NonPlayer));
    npc->quest_requested = false;
    npc->quest_complete = false;
    npc->has_key = true;
    w1->data = npc;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_extra(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = EXTRA;
    w1->draw = draw_npc;
    w1->walkable = false;
    Extra* npc = (Extra*) malloc(sizeof(Extra));
    npc -> x = x;
    npc -> y = y;
    npc -> e = false;
    w1->data = npc;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_door(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = DOOR;
    w1->draw = draw_door;
    w1->walkable = false;
    int o = false;
    w1->data = &o;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_gdoor(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = GDOOR;
    w1->draw = draw_door;
    w1->walkable = false;
    int o = false;
    w1->data = &o;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_goal(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = GOAL;
    w1->draw = draw_goal;
    w1->walkable = false;
    int o = false;
    w1->data = &o;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_spike(int x, int y)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = SPIKE;
    w1->draw = draw_spike;
    w1->walkable = true;
    int o = false;
    w1->data = &o;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_gem(int x, int y, int color)
{
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = GEM;
    int* c = &color;
    if (color == 1){
        w1->draw = draw_gem1;
        
    } else if (color == 2){
        w1->draw = draw_gem2;
    } else{
        w1->draw = draw_gem3;
    }
    w1->walkable = true;
    w1->data = c;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
}

void add_redhouse(int x, int y, int key){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = HOUSE;
    w1->draw = draw_rhouse1;
    w1->walkable = false;
    MapItem* w2 = (MapItem*) malloc(sizeof(MapItem));
    w2->type = HOUSE;
    w2->draw = draw_rhouse2;
    w2->walkable = false;
    MapItem* w3 = (MapItem*) malloc(sizeof(MapItem));
    w3->type = HOUSE;
    w3->draw = draw_rhouse2;
    w3->walkable = false;
    MapItem* w4 = (MapItem*) malloc(sizeof(MapItem));
    w4->type = HOUSE;
    w4->draw = draw_rhouse1;
    w4->walkable = false;
    MapItem* w5 = (MapItem*) malloc(sizeof(MapItem));
    w5->type = HOUSE;
    w5->draw = draw_rhouse2;
    w5->walkable = false;
    
    House* r = (House*)malloc(sizeof(House));
    r -> key = key;
    
    w1 -> data = r;
    w2 -> data = r;
    w3 -> data = r;
    w4 -> data = r;
    w5 -> data = r;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
    void* val1 = insertItem(get_active_map()->items, XY_KEY(x+1, y), w2);
    if (val1) free(val); // If something is already there, free it
    void* val2 = insertItem(get_active_map()->items, XY_KEY(x+1, y+1), w3);
    if (val2) free(val); // If something is already there, free it
    void* val3 = insertItem(get_active_map()->items, XY_KEY(x, y+2), w4);
    if (val3) free(val); // If something is already there, free it
    void* val4 = insertItem(get_active_map()->items, XY_KEY(x+1, y+2), w5);
    if (val4) free(val); // If something is already there, free it
    add_door(x, y+1);
}


void add_bluehouse(int x, int y, int key){
    MapItem* w1 = (MapItem*) malloc(sizeof(MapItem));
    w1->type = HOUSE;
    w1->draw = draw_bhouse1;
    w1->walkable = false;
    MapItem* w2 = (MapItem*) malloc(sizeof(MapItem));
    w2->type = HOUSE;
    w2->draw = draw_bhouse2;
    w2->walkable = false;
    MapItem* w3 = (MapItem*) malloc(sizeof(MapItem));
    w3->type = HOUSE;
    w3->draw = draw_bhouse2;
    w3->walkable = false;
    MapItem* w4 = (MapItem*) malloc(sizeof(MapItem));
    w4->type = HOUSE;
    w4->draw = draw_bhouse1;
    w4->walkable = false;
    MapItem* w5 = (MapItem*) malloc(sizeof(MapItem));
    w5->type = HOUSE;
    w5->draw = draw_bhouse2;
    w5->walkable = false;
    
    House* r = (House*)malloc(sizeof(House));
    r -> key = key;
    
    w1 -> data = r;
    w2 -> data = r;
    w3 -> data = r;
    w4 -> data = r;
    w5 -> data = r;
    void* val = insertItem(get_active_map()->items, XY_KEY(x, y), w1);
    if (val) free(val); // If something is already there, free it
    void* val1 = insertItem(get_active_map()->items, XY_KEY(x+1, y), w2);
    if (val1) free(val); // If something is already there, free it
    void* val2 = insertItem(get_active_map()->items, XY_KEY(x+1, y+1), w3);
    if (val2) free(val); // If something is already there, free it
    void* val3 = insertItem(get_active_map()->items, XY_KEY(x, y+2), w4);
    if (val3) free(val); // If something is already there, free it
    void* val4 = insertItem(get_active_map()->items, XY_KEY(x+1, y+2), w5);
    if (val4) free(val); // If something is already there, free it
    add_door(x, y+1);
}
