// This header has all the (extern) declarations of the globals.
// "extern" means "this is instantiated somewhere, but here's what the name
// means.
#include "globals.h"

#include "hardware.h"
#include "mbed.h"


// We need to actually instantiate all of the globals (i.e. declare them once
// without the extern keyword). That's what this file does!

// Hardware initialization: Instantiate all the things!
uLCD_4DGL uLCD(p9,p10,p11);             // LCD Screen (tx, rx, reset)
//SDFileSystem sd(p5, p6, p7, p8, "sd");  // SD Card(mosi, miso, sck, cs)
Serial pc(USBTX,USBRX);                 // USB Console (tx, rx)
MMA8452 acc(p28, p27, 100000);        // Accelerometer (sda, sdc, rate)
DigitalIn button1(p21);                 // Pushbuttons (pin)
DigitalIn button2(p22);
DigitalIn button3(p23);
AnalogOut DACout(p18);                  // Speaker (pin)
PwmOut speaker(p26);
wave_player waver(&DACout);

// Some hardware also needs to have functions called before it will set up
// properly. Do that here.
int hardware_init()
{
    // Crank up the speed
    uLCD.baudrate(3000000);
    pc.baud(115200);
        
    //Initialize pushbuttons
    button1.mode(PullUp); 
    button2.mode(PullUp);
    button3.mode(PullUp);
    
    return ERROR_NONE;
}

int butt1;

void debounce(){
    int _counter = 0;
    int _samples = 10;
    int _shadow = 0;
    
    if (!button1) { 
        if (_counter < _samples) _counter++; 
        if (_counter == _samples) _shadow = 1; 
    }
    else { 
        if (_counter > 0) _counter--; 
        if (_counter == 0) _shadow = 0; 
    }
    butt1 = _shadow;
}

GameInputs read_inputs() 
{
    Ticker ticker;
    //ticker.attach(&debounce, 1000);
    GameInputs in;
    acc.readXGravity(&in.ax);
    acc.readYGravity(&in.ay);
    acc.readZGravity(&in.az);
    //uLCD.locate(1,1);
    //uLCD.printf("%f\n", butt1);
    
    in.b1 = button1;//butt1;
    in.b2 = button2;
    in.b3 = button3;
    return in;
}
