// Project includes
#include "globals.h"
#include "hardware.h"
#include "map.h"
#include "graphics.h"
#include "speech.h"

// Functions in this file
int get_screen_action (GameInputs inputs);
int update_screen (int action);
void draw_screen (int init);
void init_screen ();
int gameover();

//global variables
int yes;
int no;
int yes_color;
int no_color;
int current_item2 = 0;


/**
 * Given the game inputs, determine what kind of update needs to happen.
 * Possbile return values are defined below.
 */
#define NO_ACTION 0
#define CHANGE_OPTION 1
#define SELECT 2

int get_screen_action(GameInputs inputs)
{
    if (!inputs.b1){
        return CHANGE_OPTION;
    } if (!inputs.b2){
        return SELECT;
    }
    return NO_ACTION;
}


#define NO_RESULT 0
#define FULL_DRAW 2
int update_screen(int action)
{
    switch(action)
    {
        case CHANGE_OPTION: 
            //if button 1 pressed move to next menu item
            current_item2 = current_item2++;
            break;
        case SELECT:
            if (current_item2%2 == 0) {//Start game
                yes = true;
            } else if (current_item2%2 == 1){ //Quit (screen cut to black)
                no = true;
            }
            break;
    }
    return NO_RESULT;
}

/**
 * Entry point for frame drawing. This should be called once per iteration of
 * the game loop. This draws all tiles on the screen, followed by the status 
 * bars. Unless init is nonzero, this function will optimize drawing by only 
 * drawing tiles that have changed from the previous frame.
 */
void draw_screen(int init)
{
       
    if (current_item2%2 == 0){
        yes_color = GREEN;
    } else if (current_item2%2 == 1){
        no_color = GREEN;
    }
    
    uLCD.locate(1,9);
    uLCD.color(yes_color);
    uLCD.printf("YES");
    
    uLCD.locate(1,10);
    uLCD.color(no_color);
    uLCD.printf("NO");
 
    yes_color = BLACK;
    no_color = BLACK;    
}

/**
 * Initialize the main world map. Add walls around the edges, interior chambers,
 * and plants in the background so you can see motion.
 */
void init_screen(int lives)
{
    uLCD.locate(1,5);
    //draw pink rectangle on whole screen
    uLCD.filled_rectangle(0, 128, 128, 80, 0xFFFFFF);
    // write title
    uLCD.textbackground_color(0xFFFFFF);
    uLCD.color(BLACK);
    uLCD.printf("GAME OVER!");
    
    if (current_item2%2 == 0){
        yes_color = RED;
    } else if (current_item2%2 == 1){
        no_color = RED;
    }
    
    uLCD.locate(1,7);
    uLCD.printf("Continue Game?");
    
    uLCD.locate(1,8);
    char str[30];
    sprintf(str, "%d lives left.", lives);
    uLCD.printf(str);
    
    uLCD.locate(1,9);
    uLCD.color(yes_color);
    uLCD.printf("YES");
    
    uLCD.locate(1,10);
    uLCD.color(no_color);
    uLCD.printf("NO");
    
}

/**
 * Program entry point! This is where it all begins.
 * This function orchestrates all the parts of the game. Most of your
 * implementation should be elsewhere - this holds the game loop, and should
 * read like a road map for the rest of the code.
 */
int gameover(int lives)
{
    // Initialize the maps
    init_screen(lives);

    // Initial drawing
    draw_screen(true);

    // Main game loop
    while(1)
    {
        // Timer to measure game update speed
        Timer t; t.start();
        
        // Actually do the game update:
        // 1. Read inputs  
            GameInputs in = read_inputs();
        // 2. Determine action (get_action) 
            int a = get_screen_action(in);       
        // 3. Update game (update_game)
            int u = update_screen(a);
        // 4. Draw frame (draw_game)
        draw_screen(u);
        
        //check for start
        if (yes){
            return 1;
        }else if (no){
            return 0;
        }
        
        
        // 5. Frame delay
        t.stop();
        int dt = t.read_ms();
        if (dt < 500) wait_ms(500 - dt);
    }
}