#include "globals.h"
#include "hardware.h"
#include "map.h"
#include "graphics.h"
#include "speech.h"
#include "startmenu.h"
#include <vector>

//note when you define stuff up here like this the methods of the class cant see it I think
#define NO_ACTION 0
#define BUTTON1 1
#define BUTTON2 2
#define BUTTON3 3
#define MENU_BUTTON 4
#define GO_LEFT 5
#define GO_RIGHT 6
#define GO_UP 7
#define GO_DOWN 8
#define NO_RESULT 9
#define GAME_OVER 10
#define FULL_DRAW 11


int Menu::get_action(GameInputs inputs){
    if(!inputs.b1){
        return 1;
    }
    if(!inputs.b2){
        return 2;
    }
    if (!inputs.b3){
        return BUTTON3;
    }
    return NO_ACTION;
}


int Menu::display(){
    ASSERT_P(hardware_init() == ERROR_NONE, "Hardware init failed!");
    // Menu loop
    while(1)
    {
        // Timer to measure game update speed
        Timer t; t.start();
        
        // Actually do the game update:
        // 1. Read inputs  
            GameInputs in = read_inputs();
        // 2. Determine action (get_action) 
            int a = this->get_action(in);      
        // 3. Update game (update_game)
            int u = this->update(a);
        
        // 4. Draw frame (draw_game)
        this->draw(u);
        
        //check for start
        if (terminate){
            uLCD.filled_rectangle(0, 127, 127, 0, 0x000000);
            return terminate;
        }
        
        // 5. Frame delay
        t.stop();
        int dt = t.read_ms();
        if (dt < 500) wait_ms(500 - dt);
    }
}

StartMenu::StartMenu() : start(0), quit(0), start_color(BLACK), quit_color(BLACK), third_color(BLACK){

    //draw pink rectangle on whole screen
    uLCD.filled_rectangle(0, 127, 127, 0, PINK1);

    // write title
    uLCD.locate(1,2);
    uLCD.textbackground_color(YELLOW);
    uLCD.color(BLACK);
    uLCD.printf("Issa Quest");
    
}


int StartMenu::update(int action){ //this might need to rewritten

    switch(action) 
    {           
        case 1: 
            //if button 1 pressed move to next menu item
            button_presses = button_presses++;
            break;
        case 2: 
            //if button 2 pressed select menu item
            if (button_presses > 0 && button_presses%3 == 0) { //Start game
                start = true;
                terminate = true;
            } else if (button_presses%3 == 1){ //Quit (screen cut to black)
                quit = true;
            } else { 
                o_instructions();
            }
            break;
    }
    return NO_RESULT;
}

void StartMenu::draw(int init){
    
    //if statement selects which option will be highlighted
    if (button_presses%3 == 0){
        start_color = GREEN;
    } else if (button_presses%3 == 1){
        quit_color = GREEN;
    } else{
        third_color = GREEN;
    }
    
    //draws the options on the screen 
    uLCD.locate(1,4);
    uLCD.color(start_color);
    uLCD.printf("Start da game");
    
    uLCD.locate(1,6);
    uLCD.color(quit_color);
    uLCD.printf("Quit?");
    
    uLCD.locate(1,8);
    uLCD.color(third_color);
    uLCD.printf("Instructions");
    
    start_color = BLACK;
    quit_color = BLACK;
    third_color = BLACK;
}


//Option Definition//
int StartMenu::o_instructions(){
    uLCD.filled_rectangle(0, 128, 128, 80, PINK1);
    uLCD.locate(1,4);
    uLCD.textbackground_color(YELLOW);
    uLCD.color(BLACK);
    
    uLCD.printf("Go into the house and talk to the red man to start your quest. Be careful not to step on the spikes.");
    
    uLCD.locate(10,15);
    uLCD.color(GREEN);
    uLCD.printf("Back");
    
    GameInputs inp = read_inputs();
    while(1){
        if(!inp.b2){
            uLCD.filled_rectangle(0, 128, 128, 30, PINK1); //erase option
            wait(1);
            return 0;
        }
        inp = read_inputs();
        wait(1);
    }
}

int StartMenu::display(){
    int result = Menu::display();
    return result;
}

