#include "mbed.h"
#include "EthernetInterface.h"
#include "FXOS8700CQ.h"

const char* ECHO_SERVER_ADDRESS = "10.0.0.73";
const int ECHO_SERVER_PORT = 7001; // changed from example code

// TODO: figure out why this line breaks the code:
FXOS8700CQ fxos(PTE25, PTE24, FXOS8700CQ_SLAVE_ADDR1); // SDA, SCL, (addr << 1)

RawSerial pc(USBTX, USBRX);

Timer t; // Microsecond timer, 32 bit int, maximum count of ~30 minutes

int main()
{
    pc.baud(115200);
    
    printf("Starting setup.\n");

    EthernetInterface eth;
    eth.init(); // Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());

    UDPSocket sock;
    sock.init();

    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);

    char out_buffer[] = "Hello World";
    char in_buffer[256];

    t.reset();
    t.start();

    for(int i = 0; i < 20; ++i) {
        sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));

        int n = sock.receiveFrom(echo_server, in_buffer, sizeof(in_buffer));

        in_buffer[n] = '\0';
        printf("%d, %d: %s\n", t.read_us(), i, in_buffer);
        
        t.reset();
    }
    
    sock.close();
    eth.disconnect();
    
    printf("Disconnected and closed.");
    
    while(1) {}
}