/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "C12832.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500
//RGB 
PwmOut r (D5);
PwmOut g (D8);
PwmOut b (D9);

//Potentiometers
C12832 lcd(D11, D13, D12, D7, D10);

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

int main()
{
    // Initialise the digital pin LED1 as an output
    

    while (true) {
        //RGB values
        r = pot1;
        g = pot2;
        b = 0;
        //show potentiometer value om LCD
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Pot 1 = %.2f", (float)pot1);
        lcd.locate(0,14);
        lcd.printf("Pot 2 = %.2f", (float)pot2);
        //wait 0.5s
        thread_sleep_for(BLINKING_RATE_MS);
    }
}
