#include "mbed.h"
#include "rtos.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#include "MMA8451Q.h"
#include "USBMouseKeyboard.h"
#define PI 3.14159265

PwmOut led1(LED2);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
AnalogIn ain(PTC2);
Serial pc(USBTX, USBRX);
USBMouseKeyboard key_mouse;
Mutex USB_mutex;
//USBHID key_mouse;

void click_thread(void const *args)
{
    int press;
    while(true) {
        if( (ain.read()>0.3) && (press == 0) ) {
            press = 1;
            led1 != led1;
            pc.printf("%i\n", press);
            USB_mutex.lock();
            key_mouse.press(MOUSE_LEFT);
            USB_mutex.unlock();
        } else if ( (ain.read()<0.3) && (press == 1) ) {
            press = 0;
            pc.printf("%i\n", press);
            USB_mutex.lock();
            key_mouse.release(MOUSE_LEFT);
            USB_mutex.unlock();
        }
        Thread::wait(100);
    }
}

void mouse_thread(void const *args)
{
    while(true) {

        USB_mutex.lock();
        key_mouse.move(-acc.getAccX()*10, 0);
        key_mouse.move(0, acc.getAccY()*10);
        USB_mutex.unlock();
        Thread::wait(1);
    }
}

void heartbeat_thread(void const *args)
{
    int i;
    led1.period(0.001);
    while(true) {
        for(i=0; i<180; i++) {
            led1 = sin(i*PI/180);
            Thread::wait(10);
        }
    }

}

int main()
{
    Thread click(click_thread);
    Thread mouse(mouse_thread);
    Thread heartbeat(heartbeat_thread);

    led1 = 1.0;

    while (true) {
    }
}
