/*******************************************************************************
* This program demonstrates how to use ultrasonic sensor HCSR04 and  how       *
* to display measured distance on both 16x2 LCD and seven segment display      *                                                                           *
*******************************************************************************/
#include "mbed.h"
#include "hcsr04.h"
#include "TextLCD.h"
#include "SevenSegmentDisplay.h"

// Options to instantiate SevenSegmentDisplay are...
// FADE: causes the number changes to fade in smoothly
// INSTANT: causes the an instant number change
// + FLASH: causes the display to flash
SevenSegmentDisplay segmentled( FADE );
// p1_27, p1_26
HCSR04  usensor(p9,p10);// trigger, echo
// p0_9, p0_8, p1_29, p1_22, p1_21, p1_20
TextLCD lcd(p11, p12, p15, p16, p17, p18, TextLCD::LCD16x2); // rs, e, d4-d7

unsigned int dist;
int main()
{       
    while(1) {
        usensor.start();
        wait_ms(500); 
        dist=usensor.get_dist_cm();
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("cm:%ld",dist );
        if(dist<100){
            segmentled.DisplayInt(dist);
        }
        else {
            segmentled.DisplayInt(99);
        }
    }
}
