#pragma once

// This is a buffered serial reading class, using the serial interrupt introduced in mbed library version 18 on 17/11/09

// In the simplest case, construct it with a buffer size at least equal to the largest message you 
// expect your program to receive in one go.

class SerialRazor : public Serial
{
public:
    SerialRazor( size_t bufferSize, PinName tx, PinName rx );
    virtual ~SerialRazor();
    float getRoll(void);
    float getPitch(void);
    float getYaw(void);
    


private:
    
    void handleInterrupt();
    float roll;
    float pitch;
    float yaw;    
    char *m_buff;           
    uint16_t m_buffSize;
    

};