
#include "mbed.h"
#include "SerialRazor.h"

SerialRazor::SerialRazor( size_t bufferSize, PinName tx, PinName rx ) : Serial(  tx,  rx )  {

    Serial::baud(57600);
    attach( this, &SerialRazor::handleInterrupt );
    m_buff = (char *) malloc( bufferSize );
    m_buffSize = bufferSize;
}



SerialRazor::~SerialRazor()
{
    if( m_buff )
        free( m_buff );
}

void SerialRazor::handleInterrupt()
{
    
    while( Serial::readable())
    {
        for(int i=0; i< m_buffSize; i++) {
        m_buff[i] = Serial::getc();
        if(m_buff[i] == '\n') {
            m_buff[i] = 0;
            sscanf(m_buff,"!ANG:%f,%f,%f", &roll, &pitch, &yaw); 
            return;
        } 
        }   
       
    }
}



float SerialRazor::getRoll(void){

    return roll;

}

float SerialRazor::getPitch(void){

    return pitch;

}

float SerialRazor::getYaw(void){

    return yaw;

}

